#include "DummyFeatureCreator.hpp"

namespace slmotion {
  static DummyFeatureCreator DUMMY(true);

  bool DummyFeatureCreator::processRangeImplementation(frame_number_t first, 
                                                       frame_number_t last,
                                                       UiCallback*) {
    std::vector<SOM_PAK_Component> components {
      {0, "framenr", 0, 999999, SOM_PAK_Component::ValueType::INTEGER, 
          "1"}, // 0
      {1, "facecount", 0, 999999, SOM_PAK_Component::ValueType::INTEGER, 
            "1"}, // 1
    };
    std::vector<std::vector<boost::any>> features(2);

    for (size_t u = first; u < last; ++u) {
      features[0].push_back(boost::any{ int(u) });
      features[1].push_back(boost::any{int(getBlackBoard().get<std::vector<cv::Rect>>(u, FACEDETECTOR_RAW_FACE_VECTOR_BLACKBOARD_ENTRY)->size())});
    }

    getBlackBoard().set(FEATURECREATOR_FEATUREVECTOR_BLACKBOARD_ENTRY,
                        FeatureVector(components, features, first, last));
    return true;
  }
}
