#ifndef SLMOTION_DUMMY_FEATURE_CREATOR
#define SLMOTION_DUMMY_FEATURE_CREATOR

#include "FeatureCreator.hpp"
#include "RawFaceDetector.hpp"

namespace slmotion {
  /**
   * Creates a simplistic feature vector consisting of the frame
   * number and the number of faces in the given frame
   */
  class DummyFeatureCreator : public Component {
  public:
    virtual std::string getShortName() const {
      return "DummyFeatureCreator";
    }

    explicit DummyFeatureCreator(BlackBoard* blackBoard, 
                            FrameSource* frameSource) : 
      Component(blackBoard, frameSource), fps(25) {}

    void process(frame_number_t) {
      assert(false && "FeatureCreator cannot be called on a single frame.");
    }

    property_set_t getRequirements() const {
      return property_set_t {
        FACEDETECTOR_RAW_FACE_VECTOR_BLACKBOARD_ENTRY
      };
    }

    property_set_t getProvided() const {
      return property_set_t {
        FEATURECREATOR_FEATUREVECTOR_BLACKBOARD_ENTRY
      };
    }

    inline virtual std::string getComponentName() const {
      return "Dummy Feature Creator";
    }

    virtual void reset() { }

    DummyFeatureCreator(bool) : Component(true) {}

    virtual std::string getShortDescription() const {
      return "This component goes through entries on the black board, and computes some features.";
    }



    virtual std::string getLongDescription() const {
      return "This component goes through entries on the black board, and computes some features.";
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const {
      return boost::program_options::options_description();
    }

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }


  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map&, BlackBoard* blackBoard, FrameSource* frameSource) const {
      return new DummyFeatureCreator(blackBoard, frameSource);
    }

    bool processRangeImplementation(frame_number_t first, 
                                    frame_number_t last,
                                    UiCallback* uiCallback = nullptr);

    double fps;
  };
}

#endif
