#ifndef SLMOTION_EMSkinDetector
#define SLMOTION_EMSkinDetector

#include "SkinDetector.hpp"

namespace slmotion {
  class EMSkinDetector : public SkinDetector {
  public:
    /**
     * Trains the EM model
     */
    virtual void train(const std::vector<cv::Mat>& samples, 
                       const std::vector<cv::Mat>& groundTruths,
                       bool update = false);



    /**
     * Basic constructor
     */
    EMSkinDetector(BlackBoard* blackBoard, FrameSource* frameSource,
                   const ColourSpace& c = *ColourSpace::IHLS) :
      SkinDetector(blackBoard, frameSource, c) {}



  private:
    virtual void detect(const cv::Mat& inFrame, cv::Mat& outMask) = 0;
  };
}

#endif
