#ifndef SLMOTION_FACEOCCLUSIONDETECTOR
#define SLMOTION_FACEOCCLUSIONDETECTOR

#include "Component.hpp"
#include "PropagationSkinDetector.hpp"

// This is a dummy component file that can be used as a template for 
// creating actual useful components

namespace slmotion {

 const std::string FACEOCCLUSIONDETECTOR_BLACKBOARD_MASK_ENTRY = "faceocclusionmask";
  // cv::Mat CV_8UC1 binary matrix (occluded pixels non-zero)

  class FaceOcclusionDetector : public Component {
  public:
    FaceOcclusionDetector(bool) : Component(true) { }

    FaceOcclusionDetector(BlackBoard* blackBoard, FrameSource* frameSource) :
      Component(blackBoard, frameSource) { }

    virtual void process(frame_number_t /* frameNumber */){
      throw std::string("Processing of individual frames not supported"); 
    }

    bool processRangeImplementation(frame_number_t first,
                                    frame_number_t last,
                                    UiCallback* uiCallback);


    virtual std::string getShortDescription() const {
      return "Detector for occluded face areas";
    }

    virtual std::string getLongDescription() const {
      return "Dummy configuration file help text";
    }

    virtual property_set_t getRequirements() const {
      return property_set_t { SKINDETECTOR_BLACKBOARD_MASK_ENTRY };
    }

    virtual property_set_t getProvided() const {
      return property_set_t { FACEOCCLUSIONDETECTOR_BLACKBOARD_MASK_ENTRY };
    }

    virtual std::string getShortName() const {
      return "FaceOcclusionDetector";
    }

    virtual std::string getComponentName() const {
      return "FaceOcclusionDetector";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const {
      return boost::program_options::options_description();
    }

 virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }


  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;
  };

 
 
}

#endif

