#ifndef SLMOTION_FACE_SKIN_ANOMALY_DETECTOR
#define SLMOTION_FACE_SKIN_ANOMALY_DETECTOR

#include "FacialLandmarkDetector.hpp"
#include "BodyPartCollector.hpp"

namespace slmotion {
  class FaceSkinAnomalyDetector : public Component {
  public:
    typedef cv::Vec<float, 8> Vec8f;

    FaceSkinAnomalyDetector(bool) : Component(true) { }

    FaceSkinAnomalyDetector(BlackBoard* blackBoard, FrameSource* frameSource) :
      Component(blackBoard, frameSource), isTrained(false), kNeighbours(1), 
      sampleDecimationFactor(1), norm(cv::NORM_L2), autoDecimationTarget(0) { }

    virtual void process(frame_number_t frameNumber);

    virtual std::string getShortDescription() const {
      return "Face Skin Anomaly Detector";
    }

    virtual std::string getLongDescription() const {
      return "Dummy configuration file help text";
    }

    virtual property_set_t getRequirements() const {
      return property_set_t {
        SKINDETECTOR_BLACKBOARD_MASK_ENTRY,
        BODYPARTCOLLECTOR_BLACKBOARD_ENTRY,
        FACIAL_LANDMARK_BLACKBOARD_ENTRY
      };
    }

    virtual property_set_t getProvided() const {
      return property_set_t();
    }

    virtual std::string getShortName() const {
      return "FaceSkinAnomalyDetector";
    }

    virtual std::string getComponentName() const {
      return "Face Skin Anomaly Detector";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const;

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;

    virtual bool processRangeImplementation(frame_number_t first, 
                                            frame_number_t last, 
                                            UiCallback* uiCallback);

    bool train(frame_number_t first, 
               frame_number_t last);

    bool isTrained;
    std::list<std::pair<Vec8f, cv::Vec3f>> sampleVectors; ///< Landmark-distance coordinates to XYZ colour values
    int kNeighbours; ///< Number of neighbours to consider when generating the expected face image
    int sampleDecimationFactor; ///< Given n, only preserve every nth training sample
    int norm; ///< The norm to use (cv::NORM_L1 or cv::NORM_L2)
    int autoDecimationTarget; ///< An alternative to sampleDecimationFactor; the target number of samples to preserve 
  };
}

#endif

