#ifdef SLMOTION_ENABLE_LIBFLANDMARK

#include "FaceSuviSegmentator.hpp"
// #include "PropagationSkinDetector.hpp"

namespace slmotion {
  static FaceSuviSegmentator DUMMY(true);

  static double distanceFromLine(const cv::Point2f& linePointA, const cv::Point2f& linePointB,
                                 const cv::Point2f& point) {

    cv::Point2f b = linePointB - linePointA;

    cv::Point2f pa = linePointA- point;

    double projlen=(pa.x*b.x+pa.y*b.y)/(b.x*b.x+b.y*b.y);

    cv::Point2f proj = projlen*b;

    return cv::norm(pa-proj);
  }

  static bool projectionBetweenPoints(const cv::Point2f& linePointA, const cv::Point2f& linePointB,
                                 const cv::Point2f& point) {

    cv::Point2f b = linePointB - linePointA;
    cv::Point2f pa = linePointA - point;

    double projlen=(pa.x*b.x+pa.y*b.y)/(b.x*b.x+b.y*b.y);

//     std::cout << "point A=("<<linePointA.x << "," << linePointA.y << ")" << std::endl; 
//     std::cout << "point B=("<<linePointB.x << "," << linePointB.y << ")" << std::endl; 
//     std::cout << "point P=("<<point.x << "," << point.y << ")" << std::endl; 
//     std::cout << "projlen=" << projlen << std::endl;

    return projlen <=0 && projlen >= -1 ;
  }


  cv::Mat FaceSuviSegmentator::getMap(const std::vector<cv::Point2f>& facialLandmarks, 
                                       const cv::Mat& inFrameMask) {
    cv::Mat m(inFrameMask.size(), CV_8UC1, 
              cv::Scalar::all(static_cast<uchar>(SuviSegment::NIL)));

//        cv::Mat vismat(inFrameMask.size(), CV_8UC1, cv::Scalar::all(0));

    const cv::Point2f* midpoint = &facialLandmarks[0];
    const cv::Point2f* lEyei = &facialLandmarks[1]; // inner
    const cv::Point2f* rEyei = &facialLandmarks[2]; // inner
    const cv::Point2f* mouthl = &facialLandmarks[3]; // lhs   
    const cv::Point2f* mouthr = &facialLandmarks[4]; // rhs   
    const cv::Point2f* lEyeo = &facialLandmarks[5]; // outer
    const cv::Point2f* rEyeo = &facialLandmarks[6]; // outer
    const cv::Point2f* nose = &facialLandmarks[7];

    cv::Point2f avgEye = (*lEyei + *rEyei) * 0.5;
    double mouthWidth = cv::norm(*mouthl - *mouthr);

    double mouthWidthFactor = 0.25;
    cv::Point2f leftMouthToLeftEye = *lEyeo - *mouthl;
    cv::Point2f leftMouthLeftEyeNormalPoint1 = *mouthl + leftMouthToLeftEye*(mouthWidthFactor*mouthWidth/cv::norm(leftMouthToLeftEye));
    cv::Point2f leftMouthLeftEyeNormalPoint2 = leftMouthLeftEyeNormalPoint1 + cv::Point2f(leftMouthToLeftEye.y, -leftMouthToLeftEye.x);
    cv::Point2f leftMouthLeftEyeNormal = leftMouthLeftEyeNormalPoint2 - leftMouthLeftEyeNormalPoint1;

    cv::Point2f rightMouthToRightEye = *rEyeo - *mouthr;
    cv::Point2f rightMouthRightEyeNormalPoint1 = *mouthr + rightMouthToRightEye*(mouthWidthFactor*mouthWidth/cv::norm(rightMouthToRightEye));
    cv::Point2f rightMouthRightEyeNormalPoint2 = rightMouthRightEyeNormalPoint1 + cv::Point2f(rightMouthToRightEye.y, -rightMouthToRightEye.x);
    cv::Point2f rightMouthRightEyeNormal = rightMouthRightEyeNormalPoint2 - rightMouthRightEyeNormalPoint1;

    cv::Point2f avgEyeL = (*lEyei + *lEyeo) * 0.5;
    cv::Point2f avgEyeR = (*rEyei + *rEyeo) * 0.5;
    double avgEyeWidth = (cv::norm(*lEyei - *lEyeo) + 
                          cv::norm(*rEyei - *rEyeo)) * 0.5;
    
//     cv::Mat temp=inFrameMask.clone();
//       for (size_t k = 0; k < facialLandmarks.size(); ++k) 
// 	cv::circle(temp, facialLandmarks[k], 3, cv::Scalar::all(128));
//     // cv::circle(temp, avgEyeR, 3, cv::Scalar::all(255));
//     // cv::line(temp, avgEyeL, avgEyeR, cv::Scalar::all(255));
//      cv::imshow("mask with landmarks", temp);
//     cv::waitKey(0);

//     cv::Mat distmat(inFrameMask.size(),cv::DataType<float>::type,cv::Scalar::all(0));
//     cv::Mat distlm(inFrameMask.size(),cv::DataType<float>::type,cv::Scalar::all(0));
//     cv::Mat distnose(inFrameMask.size(),cv::DataType<float>::type,cv::Scalar::all(0));

    double distanceFromMouthLineToNose=distanceFromLine(*mouthl, *mouthr, *nose);

    for (int i = 0; i < inFrameMask.rows; ++i) {
      for (int j = 0; j < inFrameMask.cols; ++j) {
        if (inFrameMask.at<uchar>(i,j) > 0) {
          cv::Point2f current(j,i);
          double distanceFromNoseline = distanceFromLine(*nose, avgEye, current); 
          double distanceFromEyeLine = distanceFromLine(avgEyeL, avgEyeR, current);
	  double distanceFromMouthLine=distanceFromLine(*mouthl, *mouthr, current);

	  //	  distmat.at<float>(i,j)=distanceFromNoseline;

          const cv::Point2f* closestNeighbour = nullptr;
          double distance = DBL_MAX;
          for (size_t k = 0; k < facialLandmarks.size(); ++k) {
            if (cv::norm(facialLandmarks[k] - current) < distance) {
              distance = cv::norm(facialLandmarks[k] - current);
              closestNeighbour = &facialLandmarks[k];
            }
          }

          if ((closestNeighbour == nose || closestNeighbour == midpoint || 
               closestNeighbour == lEyei || closestNeighbour == rEyei ||
               closestNeighbour == lEyeo || closestNeighbour == rEyeo) &&
              distanceFromEyeLine > avgEyeWidth && current.y < avgEye.y) {


            m.at<uchar>(i,j) = static_cast<uchar>(SuviSegment::FOREHEAD);
	    goto label_assigned;

	  } else if ((closestNeighbour == nose || closestNeighbour == midpoint)
		&& distanceFromNoseline<=0.5*mouthWidth && 
		distanceFromMouthLine > 0.5*distanceFromMouthLineToNose){

	      m.at<uchar>(i,j) = static_cast<uchar>(SuviSegment::NOSE);

	    goto label_assigned;

	  } 

	  if(closestNeighbour == nose || closestNeighbour == midpoint){
	    // reset the closest neighbour
	    // excluding the nose landmarks
 	      closestNeighbour = nullptr;
 	      distance = DBL_MAX;
 	      for (size_t k = 1; k < facialLandmarks.size()-1; ++k) {
 		// midpoint and nose happen to be first and last landmarks
 		if (cv::norm(facialLandmarks[k] - current) < distance) {
 		  distance = cv::norm(facialLandmarks[k] - current);
 		  closestNeighbour = &facialLandmarks[k];
 		}
 	      }

// 	      std::cout << "rejected possible nose, resetting closestnoighbour to k=";
// 	      for (size_t k = 0; k < facialLandmarks.size(); ++k)
// 		if(closestNeighbour == &facialLandmarks[k])
// 		  std::cout << k;
// 	      std::cout << std::endl;

	  }

	  if (closestNeighbour == lEyei || closestNeighbour == rEyei ||
	      closestNeighbour == lEyeo || closestNeighbour == rEyeo) {

	    if(distance>distanceFromNoseline && current.y > avgEye.y &&
	       projectionBetweenPoints(*nose, avgEye, current)
	       && distanceFromNoseline <= 0.5*mouthWidth)
	      { 
		      m.at<uchar>(i,j) = static_cast<uchar>(SuviSegment::NOSE);
	      }
	    else
	      m.at<uchar>(i,j) = static_cast<uchar>(SuviSegment::CHEEKS);	  

// 	    if ((distance < distanceFromNoseline || 
// 		 !projectionBetweenPoints(*nose, avgEye, current)) || current.y < avgEye.y)
// 	      m.at<uchar>(i,j) = static_cast<uchar>(SuviSegment::CHEEKS);
// 	    else{
// 	      vismat.at<uchar>(i,j) = 255;
// 	      m.at<uchar>(i,j) = static_cast<uchar>(SuviSegment::NOSE);
// 	    }

	    goto label_assigned;

	  }

	  if (closestNeighbour == mouthl) {
	    double s = (current.x - leftMouthLeftEyeNormalPoint1.x)/leftMouthLeftEyeNormal.x;
	    cv::Point2f p = leftMouthLeftEyeNormalPoint1 + s*leftMouthLeftEyeNormal;
	    if (current.y < p.y)
	      m.at<uchar>(i,j) = static_cast<uchar>(SuviSegment::CHEEKS);
	    else if (distance < mouthWidth)
	      m.at<uchar>(i,j) = static_cast<uchar>(SuviSegment::MOUTH);
	    else 
	      m.at<uchar>(i,j) = static_cast<uchar>(SuviSegment::NECK);

	    goto label_assigned;
	  }
	  
	  if (closestNeighbour == mouthr) {
	    double s = (current.x - rightMouthRightEyeNormalPoint1.x)/rightMouthRightEyeNormal.x;
	    cv::Point2f p = rightMouthRightEyeNormalPoint1 + s*rightMouthRightEyeNormal;
	    if (current.y < p.y)
	      m.at<uchar>(i,j) = static_cast<uchar>(SuviSegment::CHEEKS);
	    else if (distance < mouthWidth)
	      m.at<uchar>(i,j) = static_cast<uchar>(SuviSegment::MOUTH);
	    else 
	      m.at<uchar>(i,j) = static_cast<uchar>(SuviSegment::NECK);

	    goto label_assigned;

	  }
	  
	  
	  m.at<uchar>(i,j) = static_cast<uchar>(SuviSegment::OTHER);

	label_assigned:
	  ;
	}


      }
    }
  
  
    
//     cv::line(distnose, *nose, avgEye, cv::Scalar::all(255));

//      imshow("nose by rule 2",vismat);
//    floatimagesc("distance from nose",distmat);
//    floatimagesc("distance from landmark",distlm);
//    floatimagesc("distance from landmark > distance from noseline",distnose);
//       cv::waitKey(0);

    return m;
  }

  void FaceSuviSegmentator::process(frame_number_t frameNumber) {

    if (!getBlackBoard().has(frameNumber, FACEDETECTOR_BLACKBOARD_ENTRY)) 
      return; // skip frames without face detection


    if (!getBlackBoard().has(frameNumber,FACIAL_LANDMARK_BLACKBOARD_ENTRY)) 
      return; // skip frames without facial landmark detections

    BlackBoardPointer<cv::Rect> faceLocation = getBlackBoard().get<cv::Rect>(frameNumber, FACEDETECTOR_BLACKBOARD_ENTRY);

    if(*faceLocation == ViolaJonesFaceDetector::INVALID_FACE)
      return; // skip frames without a valid face detection

    cv::Mat facemask=getBlackBoard().get<cv::Mat>(frameNumber, SKINDETECTOR_BLACKBOARD_MASK_ENTRY)->clone();

    // go through the mask and convert it to 0/1

    for(int x=0;x<facemask.cols;x++)
      for(int y=0;y<facemask.rows;y++)
	facemask.at<uchar>(y,x)=(facemask.at<uchar>(y,x)!=0)?1:0;

    // flood fill the connected component of the face

    cv::Point seedpoint(0.5*(faceLocation->x+faceLocation->br().x),
		    0.5*(faceLocation->y+faceLocation->br().y));

    cv::floodFill(facemask, seedpoint, cv::Scalar::all(255));

    // erase all non-filled pixels from the mask
    
    for(int x=0;x<facemask.cols;x++)
      for(int y=0;y<facemask.rows;y++)
	if(facemask.at<uchar>(y,x)!=255)
	  facemask.at<uchar>(y,x)=0;
    
  //   cv::imshow("face mask",facemask);
//     cv::waitKey(0);


//     std::list<BodyPart> bodyparts = getBlackBoard().get<std::list<BodyPart>>(frameNumber, BODYPARTCOLLECTOR_BLACKBOARD_ENTRY);
//     BodyPart* p = nullptr;
//     for (auto it = bodyparts.begin(); it != bodyparts.end(); ++it) 
//       if (it->isA(BodyPart::HEAD)) 
//         p = &*it;
//     assert(p);

//     cv::Mat faceMask = p->getBlob().toMatrix(getFrameSource()[0].size());

    BlackBoardPointer<std::vector<cv::Point2f> > facialLandmarks = getBlackBoard().get<std::vector<cv::Point2f>>(frameNumber, FACIAL_LANDMARK_BLACKBOARD_ENTRY);

    getBlackBoard().set(frameNumber, FACESUVISEGMENTS_BLACKBOARD_ENTRY, 
                        getMap(*facialLandmarks, facemask));
  }

  Component* FaceSuviSegmentator::createComponentImpl(const boost::program_options::variables_map&, BlackBoard* blackBoard, FrameSource* frameSource) const {
    return new FaceSuviSegmentator(blackBoard, frameSource);
  }
}

#endif
