#ifdef SLMOTION_ENABLE_LIBFLANDMARK
#ifndef SLMOTION_FACE_SUVI_SEGMENTATOR
#define SLMOTION_FACE_SUVI_SEGMENTATOR

#include "FacialLandmarkDetector.hpp"
#include "BodyPartCollector.hpp"

namespace slmotion {
  const std::string FACESUVISEGMENTS_BLACKBOARD_ENTRY = "facesuvisegments";
  // cv::Mat of type CV_8UC1
  // where each segment is represented by enumeration values (of type SuviSegment)

  enum class SuviSegment : uchar {
    NIL = 0, CHEEKS = 1, NOSE = 2, MOUTH = 4, NECK = 8, FOREHEAD = 16, OTHER = 32
  };



  /**
   * Segments the facial skin into segments, corresponding to possible
   * articulatory locations in the Suvi dictionary, as shown here:
   * http://suvi.viittomat.net/Index.aspx?c=search;1&type=3 on the first row
   */
  class FaceSuviSegmentator : public Component {
  public:
    typedef cv::Vec<float, 8> Vec8f;

    FaceSuviSegmentator(bool) : Component(true) { }

    FaceSuviSegmentator(BlackBoard* blackBoard, FrameSource* frameSource) :
      Component(blackBoard, frameSource) { }

    virtual void process(frame_number_t frameNumber);

    virtual std::string getShortDescription() const {
      return "Face area mapper";
    }

    virtual std::string getLongDescription() const {
      return "Dummy configuration file help text";
    }

    virtual property_set_t getRequirements() const {
      // return property_set_t {
//         FACIAL_LANDMARK_BLACKBOARD_ENTRY, BODYPARTCOLLECTOR_BLACKBOARD_ENTRY
//       };

      return property_set_t {
        FACIAL_LANDMARK_BLACKBOARD_ENTRY,  FACEDETECTOR_BLACKBOARD_ENTRY, SKINDETECTOR_BLACKBOARD_MASK_ENTRY
       };


    }

    virtual property_set_t getProvided() const {

      return property_set_t {
	FACESUVISEGMENTS_BLACKBOARD_ENTRY
       };
    }

    virtual std::string getShortName() const {
      return "FaceSuviSegmentator";
    }

    virtual std::string getComponentName() const {
      return "Face Suvi Segmentator";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const {
      return boost::program_options::options_description();
    }

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

    /**
     * Given the set of facial landmarks, classifies each pixel in the input
     * frame into Suvi segments, then returns a map of the same size but of type
     * CV_8UC1 where each element is a segment enum. The same function is called
     * by the process() function of this component.
     *
     * @param flandmarks Facial landmarks as returned by the facial landmark 
     * detector
     *
     * @param inFrame Input frame mask. A binary image of type CV_8UC1 where 
     * non-zero entries represent pixels that are part of the face and should
     * be classified. Any zero pixels will be assigned a NIL value.
     */
    static cv::Mat getMap(const std::vector<cv::Point2f>& flandmarks, 
                          const cv::Mat& inFrameMask);

  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;
  };
}

#endif // SLMOTION_FACE_SUVI_SEGMENTATOR
#endif // SLMOTION_ENABLE_LIBFLANDMARK
