#ifdef SLMOTION_ENABLE_LIBFLANDMARK
#ifndef SLMOTION_FACIAL_LANDMARK_DETECTOR
#define SLMOTION_FACIAL_LANDMARK_DETECTOR

#include "SkinDetector.hpp"
#include "FaceDetector.hpp"
#include <flandmark_detector.h>

namespace slmotion {
  const std::string FACIAL_LANDMARK_BLACKBOARD_ENTRY = "faciallandmarks";
  // std::vector<cv::Point2f>
  const std::string FACIAL_LANDMARK_CONFIDENCE_BLACKBOARD_ENTRY = "faciallandmarkconfidence";
  // double

  const char* getLibFlandmarkModel();

  class FacialLandmarkDetector : public Component {
  public:
    FacialLandmarkDetector(bool);

    FacialLandmarkDetector(BlackBoard* blackBoard, 
                           FrameSource* frameSource) :
      Component(blackBoard, frameSource),
      model(flandmark_init(getLibFlandmarkModel())),
      enableConfidence(false),
      confidenceThreshold(0.65),
      enableLowpassFilter(false),
      lowPassCutoff(8.0)
    {    }

    FacialLandmarkDetector(const FacialLandmarkDetector& other) :
      Component(*static_cast<const Component*>(&other)),
      model(flandmark_init(getLibFlandmarkModel())),
      enableConfidence(other.enableConfidence),
      confidenceThreshold(other.confidenceThreshold),
      enableLowpassFilter(other.enableLowpassFilter),
      lowPassCutoff(other.lowPassCutoff)
    {
    }

    FacialLandmarkDetector& operator=(const FacialLandmarkDetector&) = delete;
    virtual ~FacialLandmarkDetector(); 

    virtual void process(frame_number_t frameNumber);

    virtual std::string getShortDescription() const {
      return "Facial landmark detector";
    }

    virtual std::string getLongDescription() const {
      return "Facial landmark detector";
    }

    virtual property_set_t getRequirements() const;

    virtual property_set_t getProvided() const;

    virtual std::string getShortName() const {
      return "FacialLandmarkDetector";
    }

    virtual std::string getComponentName() const {
      return "Facial Landmark Detector";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const;

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  protected:
    /**
     * Given the face and the input frame, computes the facial landmark points
     */
    std::vector<cv::Point2f> getPointsForFace(const cv::Rect& face, const cv::Mat& inFrame);

  private:
    /**
     * Does low-pass filtering when needed
     */
    virtual bool processRangeImplementation(frame_number_t first, 
                                            frame_number_t last, 
                                            UiCallback* uiCallback);



    /**
     * Low-pass filters the detections.
     * @param first First frame (inclusive)
     * @param last Last frame (exclusive)
     */
    void lowpassfilter(frame_number_t first, frame_number_t last);


    void pruneAndInterpolate(frame_number_t first, frame_number_t last);


    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;
    FLANDMARK_Model* model;
    bool enableConfidence; ///< If enabled, confidence values will be stored along with the actual landmarks
    double confidenceThreshold;
    bool enableLowpassFilter;
    bool pruneandinterpolate;
    double lowPassCutoff;
  };
}

#endif
#endif
