#ifndef SLMOTION_FACIAL_STATE
#define SLMOTION_FACIAL_STATE

#include "Component.hpp"
#include "util.hpp"
#include "FaceDetector.hpp"
#include "FaceAlignment.h"
#include "XXDescriptor.h"

namespace slmotion {
  const std::string DEFAULT_EIG_EYEBROW = getInstallPrefix()+"/share/slmotion/models/sfe_eyebrow.eig";
  const std::string DEFAULT_EIG_EYE     = getInstallPrefix()+"/share/slmotion/models/sfe_eye.eig";
  const std::string DEFAULT_EIG_VMOUTH  = getInstallPrefix()+"/share/slmotion/models/sfe_vmouth.eig";
  const std::string DEFAULT_EIG_HMOUTH  = getInstallPrefix()+"/share/slmotion/models/sfe_hmouth.eig";

  const std::string DEFAULT_MODEL_EYEBROW = getInstallPrefix()+"/share/slmotion/models/sfe_eyebrow_nb.model";
  const std::string DEFAULT_MODEL_EYE     = getInstallPrefix()+"/share/slmotion/models/sfe_eye_nb.model";
  const std::string DEFAULT_MODEL_VMOUTH  = getInstallPrefix()+"/share/slmotion/models/sfe_vmouth_nb.model";
  const std::string DEFAULT_MODEL_HMOUTH  = getInstallPrefix()+"/share/slmotion/models/sfe_hmouth_nb.model";
  const unsigned int DEFAULT_START_IX = 1;
  const unsigned int DEFAULT_END_IX = 5;
  const float STEP = 0.004;
  const unsigned int DEFAULT_FRAME_WIDTH = 10;
  const unsigned int DEFAULT_FRAME_HEIGHT = 40;
  const unsigned int DEFAULT_ANN_HEIGHT = 20;
  const unsigned int DEFAULT_ANN_MARK = 10;
  const bool DEFAULT_CREATE_TIMELINE = true;

  const std::string MODEL_TRACK  = getIntrafacePrefix()+"/models/TrackingModel-v1.10.bin";
  const std::string MODEL_DETECT = getIntrafacePrefix()+"/models/DetectionModel-v1.5.bin";
  const INTRAFACE::XXDescriptor XXDESCRIPTOR(4);
  const std::string FACIAL_STATE_BLACKBOARD_ENTRY = "facialstate";

  class FacialStateEstimator : public Component {
  public:
    FacialStateEstimator(bool) : Component(true) { }

    FacialStateEstimator(BlackBoard* blackBoard, FrameSource* frameSource) : 
      Component(blackBoard, frameSource),
      startIx(DEFAULT_START_IX),
      endIx(DEFAULT_END_IX),      
      eigEyebrow(DEFAULT_EIG_EYEBROW),
      eigEye(DEFAULT_EIG_EYE),
      eigVmouth(DEFAULT_EIG_VMOUTH),
      eigHmouth(DEFAULT_EIG_HMOUTH),
      modEyebrow(DEFAULT_MODEL_EYEBROW),
      modEye(DEFAULT_MODEL_EYE),
      modVmouth(DEFAULT_MODEL_VMOUTH),
      modHmouth(DEFAULT_MODEL_HMOUTH),
      modTrack(MODEL_TRACK),
      modDetect(MODEL_DETECT),
      frWidth(DEFAULT_FRAME_WIDTH),
      frHeight(DEFAULT_FRAME_HEIGHT),
      annBar(DEFAULT_ANN_HEIGHT),
      annCol(DEFAULT_ANN_MARK),
      includeTimeline(DEFAULT_CREATE_TIMELINE){
    }

    FacialStateEstimator& operator=(const FacialStateEstimator&) = delete;
    virtual ~FacialStateEstimator(); 

    virtual void process(frame_number_t frameNumber);

    inline void setFrWidth(int x){
      frWidth = x;
    }

    inline void setFrHeight(int x){
      frHeight = x;
    }

    inline void setAnnBar(int x){
      annBar = x;
    }

    inline void setAnnCol(int x){
      annCol = x;
    }

    inline void setIncludeTimeline(bool x){
      includeTimeline = x;
    }

    inline void setStartSeed(int x){
      if (x>0)
        startIx = x-1;
      else
        startIx = DEFAULT_START_IX-1;
    }

    inline void setEndSeed(int x){
      if (x>0)
        endIx = x-1;
      else
        endIx = DEFAULT_END_IX-1;
    }

    inline void setEigEyebrow(std::string x) {
      eigEyebrow = x;
    }

    inline void setEigEye(std::string x) {
      eigEye = x;
    }

    inline void setEigVmouth(std::string x) {
      eigVmouth = x;
    }

    inline void setEigHmouth(std::string x) {
      eigHmouth = x;
    }

    inline void setModEyebrow(std::string x) {
      modEyebrow = x;
    }

    inline void setModEye(std::string x) {
      modEye = x;
    }

    inline void setModVmouth(std::string x) {
      modVmouth = x;
    }

    inline void setModHmouth(std::string x) {
      modHmouth = x;
    }

    inline void setModTrack(std::string x) {
      modTrack = x;
    }

    inline void setModDetect(std::string x) {
      modDetect = x;
    }

    virtual std::string getShortDescription() const {
      return "Facial state estimator";
    }

    virtual std::string getLongDescription() const {
      return "Estimates eyebrow position, eye openness, vertical mouth state, and horizontal mouth state.";
    }

    virtual property_set_t getRequirements() const;

    virtual property_set_t getProvided() const {
      return property_set_t();
    }

    virtual std::string getShortName() const {
      return "FacialStateEstimator";
    }

    virtual std::string getComponentName() const {
      return "Facial State Estimator";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const;

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;
    unsigned int startIx;
    unsigned int endIx;
    std::string eigEyebrow;
    std::string eigEye;
    std::string eigVmouth;
    std::string eigHmouth;
    std::string modEyebrow;
    std::string modEye;
    std::string modVmouth;
    std::string modHmouth;
    std::string modTrack;
    std::string modDetect;
    cv::Mat X0;
    unsigned int frWidth;  // size of each frame in the image
    unsigned int frHeight; // height of each frame in the image
    unsigned int annBar;   // size of annotation bar
    unsigned int annCol;   // every N marked frames in annotation bar
    bool includeTimeline;
    INTRAFACE::FaceAlignment* faceDetector;
    
    virtual bool processRangeImplementation(frame_number_t first, frame_number_t last, UiCallback* uiCallback);

  };
}

#endif
