#include "FeatureExtractor.hpp"
#include <opencv2/opencv.hpp>

using std::vector;
using std::string;

using cv::Mat;
using cv::Range;
using cv::Point;
using cv::Vec3b;
using cv::Vec3f;
using cv::Vec3d;
using cv::Rect;
using cv::Scalar;



namespace slmotion {

  void FeatureExtractor::extractFeatures( vector<float> &dst,size_t x, size_t y, size_t frame, localBlackBoardType &bb){

    // currently, feature extraction methods are just written here one
    // after another

    // at the moment, only one feature is extracted, the pixel colour

    Mat f=*boost::any_cast<cv::Mat>(&bb[std::pair<int,std::string>(frame,"frame")]);


    dst=vector<float>(6);


    uchar b=f.at<Vec3b>(x,y)[0];
    uchar g=f.at<Vec3b>(x,y)[1];
    uchar r=f.at<Vec3b>(x,y)[2];
	   
     uchar v=r;
    if(g>v) v=g;
    if(b>v) v=b;
    
    float s=0;
    if(v!=0){
      uchar m=r;
      if(g<m) m=g;
      if(b<m) m=b;
      
      s=v-m;
      s /= v;
    }

    float h=0;

    if(s!=0){
      
      h=atan(sqrt(3)*(g-b)/(2*r-g-b));
      while(h<0) h += 2*3.141592654;
      dst[0]=s*v*cos(h);
      dst[1]=s*v*sin(h);
    } else
      dst[0]=dst[1]=0;
	   
    dst[2]=v;

    dst[0]=b;
    dst[1]=g;
    dst[2]=r;

     dst[3]=(v<10)?0:cos(h);
     dst[4]=(v<10)?0:sin(h);
     dst[5]=(v<10)?0:s;

    return;


//      // absolute values of derivatives in x,y and t-direction
//      if(x>0){
//        Vec3b diff=f.at<cv::Vec3b>(x,y)-f.at<cv::Vec3b>(x-1,y);
//        dst[3]=sqrt(diff.dot(diff));
//      } else
//        dst[3]=0;

//      if(y>0){
//        Vec3b diff=f.at<cv::Vec3b>(x,y)-f.at<cv::Vec3b>(x,y-1);
//        dst[4]=sqrt(diff.dot(diff));
//      } else
//        dst[4]=0;

//      if(frame>0){
//        Mat pf=*boost::any_cast<cv::Mat>(&bb[std::pair<int,std::string>(frame-1,"frame")]);
//        Vec3b diff=f.at<cv::Vec3b>(x,y)-pf.at<cv::Vec3b>(x,y);
//        dst[5]=sqrt(diff.dot(diff));
//      } else
//        dst[5]=0;

//      // average colour in a 5x5 neighbourhood;

//      dst[6]=dst[7]=dst[8]=0;

//      for(int yy=y-2;yy<=y+2;yy++)
//        for(int xx=x-2;xx<=x+2;xx++)
// 	 if(!(xx<0 || yy<0 || xx>=f.rows||yy>=f.cols)){
// 	   dst[6] += f.at<cv::Vec3b>(xx,yy)[0];
// 	   dst[7] += f.at<cv::Vec3b>(xx,yy)[1];
// 	   dst[8] += f.at<cv::Vec3b>(xx,yy)[2];
// 	 }


//      dst[6] /= 25;
//      dst[7] /= 25;
//      dst[8] /= 25;

//      //cerr << "extracted feature vector: ";
//      //for(size_t d=0;d<dst.size();d++)
//      //  cerr << dst[d] << " ";
//      //cerr << endl;

//      // local binary pattern

     
//      if(bb.count(std::pair<int,std::string>(frame,"intensity"))==0){
//        Mat i = Mat(f.size(), CV_32FC1, cv::Scalar::all(0));

//        for(size_t x=0;x<i.rows;x++)
// 	 for(size_t y=0;y<i.cols;y++)
// 	   i.at<float>(x,y)=(f.at<Vec3b>(x,y)[0]+f.at<Vec3b>(x,y)[1]+f.at<Vec3b>(x,y)[2])/768.0;


//        bb[std::pair<int,std::string>(frame,"intensity")]=i.clone();
//      }

//      Mat i=*boost::any_cast<cv::Mat>(&bb[std::pair<int,std::string>(frame,"intensity")]);

//      if(x>0 && x<f.rows && y > 0 && y < f.cols){

//        int xincr[]={-1,-1,-1,0,1,1,1,0};
//        int yincr[]={-1,0,1,1,1,0,-1,-1};
       
//        int mask=1;
//        int code=0;

//        float margin=0.03;
       
//        for(int dir=0;dir<8;dir++){
// 	 if(i.at<float>(x+xincr[dir],y+yincr[dir])>i.at<float>(x,y)+margin)
// 	   code |= mask;
// 	 mask <<= 1;
	 
//        }
//        dst[9]=code;

//        }
//        else dst[9]=0;
  
  

     // colour moments
     
     // form integral images of 1st, 2nd and 3rd moments of HSVtrig representation
     
     if(bb.count(std::pair<int,std::string>(frame,"HSVtrigint"))==0
       ||
       bb.count(std::pair<int,std::string>(frame,"HSVtrigpow2int"))==0 ||
       bb.count(std::pair<int,std::string>(frame,"HSVtrigpow3int"))==0){
       
        Mat i1 = Mat(f.size()+cv::Size(1,1), CV_64FC3, cv::Scalar::all(0));
	Mat i2 = Mat(f.size()+cv::Size(1,1), CV_64FC3, cv::Scalar::all(0));
	Mat i3 = Mat(f.size()+cv::Size(1,1), CV_64FC3, cv::Scalar::all(0));

        // for(size_t x=0;x<f.rows;x++)
 	//  for(size_t y=0;y<f.cols;y++){
        for (int x = 0; x < f.rows; x++)
	  for (int y = 0; y < f.cols; y++){
	   
	    uchar b=f.at<Vec3b>(x,y)[0];
	    uchar g=f.at<Vec3b>(x,y)[1];
	    uchar r=f.at<Vec3b>(x,y)[2];
	    
	    
	    
	    uchar v=r;
	    if(g>v) v=g;
	    if(b>v) v=b;

	    float s=0;
	    if(v!=0){
	      uchar m=r;
	      if(g<m) m=g;
	      if(b<m) m=b;

	      s=v-m;
	      s /= v;
	    }


	    Vec3d current,current2;
	   
	    if(s!=0){

	      float h=atan(sqrt(3)*(g-b)/(2*r-g-b));




	      current[0]=s*v*cos(h);
	      current[1]=s*v*sin(h);
	    } else
	      current[0]=current[1]=0;
	   
	    current[2]=v;

	    // 	   //	   current[0]=r;
	    // 	   //	   current[1]=g;
	    // 	   //	   current[2]=b;


	    // 	   //	   cout << "(r,g,b)=("<<(int)r<<","<<(int)g<<","<<(int)b<<") -> current=("<<current[0]<<","<<current[1]<<","<<current[2]<<")" <<endl;

	    i1.at<Vec3d>(x+1,y+1) =  i1.at<Vec3d>(x+1,y) +
	      i1.at<Vec3d>(x,y+1)-i1.at<Vec3d>(x,y)+current;      

	    current2[0] = current[0]*current[0];
	    current2[1] = current[1]*current[1];
	    current2[2] = current[2]*current[2];

	    i2.at<Vec3d>(x+1,y+1) =  i2.at<Vec3d>(x+1,y) +
	      i2.at<Vec3d>(x,y+1)-i2.at<Vec3d>(x,y)+current2;      

	    current2[0] *= current[0];
	    current2[1] *= current[1];
	    current2[2] *= current[2];
	   
	    i3.at<Vec3d>(x+1,y+1) =  i3.at<Vec3d>(x+1,y) +
	      i3.at<Vec3d>(x,y+1)-i3.at<Vec3d>(x,y)+current2;      

	  }

        bb[std::pair<int,std::string>(frame,"HSVtrigint")]=i1.clone();
	bb[std::pair<int,std::string>(frame,"HSVtrigpow2int")]=i2.clone();
	bb[std::pair<int,std::string>(frame,"HSVtrigpow3int")]=i3.clone();

      }

      Mat i1=*boost::any_cast<cv::Mat>(&bb[std::pair<int,std::string>(frame,"HSVtrigint")]);
      Mat i2=*boost::any_cast<cv::Mat>(&bb[std::pair<int,std::string>(frame,"HSVtrigpow2int")]);
      Mat i3=*boost::any_cast<cv::Mat>(&bb[std::pair<int,std::string>(frame,"HSVtrigpow3int")]);
     
//      // integral images formed, now calculate central moments
 
//      // print out a part of the images for checking

//     //  cerr << "frame channel 2" << endl;
// //      for(size_t x=0;x<8;x++){
// //        for(size_t y=0;y<8;y++)
// // 	 cerr << (int) f.at<Vec3b>(f.rows-x-1,f.cols-y-1)[2] << " ";
// //        cerr << endl;
// //      }

// //      cerr << "i1 channel 0" << endl;
// //      for(size_t x=0;x<8;x++){
// //        for(size_t y=0;y<8;y++)
// // 	 cerr << i1.at<Vec3d>(i1.rows-x-1,i1.cols-y-1)[0] << " ";
// //        cerr << endl;
// //      }

// //      cv::waitKey(0);

      int momentradius=32; // 
     
      int minx=x-momentradius;
      int miny=y-momentradius;
      int maxx=x+momentradius;
      int maxy=y+momentradius;
     
     
      if(minx<0) minx=0;
      if(miny<0) miny=0;
      if(maxx>=f.rows) maxx=f.rows-1; 
      if(maxy>=f.cols) maxy=f.cols-1;

      // raw moments
      float sizemul=1;
      sizemul /= (2*momentradius+1)*(2*momentradius+1);
     
      Vec3d mu=i1.at<Vec3d>(maxx+1,maxy+1)-i1.at<Vec3d>(minx,maxy+1)-
      	       i1.at<Vec3d>(maxx+1,miny)+i1.at<Vec3d>(minx,miny);
     
      mu *= sizemul;

  Vec3d mu2=i2.at<Vec3d>(maxx+1,maxy+1)-i2.at<Vec3d>(minx,maxy+1)-
			i2.at<Vec3d>(maxx+1,miny)+i2.at<Vec3d>(minx,miny);
      mu2 *= sizemul;

      Vec3d mu3=i3.at<Vec3d>(maxx+1,maxy+1)-i3.at<Vec3d>(minx,maxy+1)-
 			i3.at<Vec3d>(maxx+1,miny)+i3.at<Vec3d>(minx,miny);
      mu3 *= sizemul;

     // mean

      dst[3]=mu[0];
      dst[4]=mu[1];
      dst[5]=mu[2];

      // variance
     
      dst[6]=mu2[0]-mu[0]*mu[0];
      dst[7]=mu2[1]-mu[1]*mu[1];
      dst[8]=mu2[2]-mu[2]*mu[2];

      dst[6]=pow(fabs(dst[6]),0.5)*(dst[6]>0 ? 1 : -1);
      dst[7]=pow(fabs(dst[7]),0.5)*(dst[7]>0 ? 1 : -1);
      dst[8]=pow(fabs(dst[8]),0.5)*(dst[8]>0 ? 1 : -1);

// //      // skewness = E[X^3]-3E[X]E[X^2]+2E[X]^3
     
      dst[9]=mu3[0]-3*mu[0]*mu2[0]+2*mu[0]*mu[0]*mu[0];
      dst[9]=pow(fabs(dst[9]),0.333)*(dst[9]>0 ? 1 : -1);
      dst[10]=mu3[1]-3*mu[1]*mu2[1]+2*mu[1]*mu[1]*mu[1];
      dst[10]=pow(fabs(dst[10]),0.333)*(dst[10]>0 ? 1 : -1);
      dst[11]=mu3[2]-3*mu[2]*mu2[2]+2*mu[2]*mu[2]*mu[2];
      dst[11]=pow(fabs(dst[11]),0.333)*(dst[11]>0 ? 1 : -1);


  }
}
