#ifndef SLMOTION_FEATURE_EXTRACTOR
#define SLMOTION_FEATURE_EXTRACTOR

#include "BlackBoard.hpp"
#include <vector>


typedef std::map<std::pair<int,std::string>,boost::any> localBlackBoardType;


namespace slmotion {
  /* defines the interface of pixelwise feature extraction */
  class FeatureExtractor {
  public:

    void extractFeatures( std::vector<float> &dst,size_t x, size_t y, size_t frame, localBlackBoardType &bb);

    size_t numberOfFeatures(){ return 1;}

    std::string featureName(size_t idx){
      switch(idx){
      case 0:
	 return "HSVtrig";
	//      case 1:
      case 1:
	return "HSVTrig moments";

      case 2:
	return "fusion";
	//return "HSVtrig+HSVtrig_ave";

/* 	return "gradient component magnitudes"; */
/*       case 2: */
/* 	return "average colour"; */
/*       case 3: */
/* 	return "colour+LBP"; */

/*       case 4: */
/* 	return "LBP"; */
/*       case 1: */
/* 	return "average HSVtrig"; */
/*       case 2: */
/* 	return "BGR+average HSVtrig"; */

      default:	
	return "unknown feature";
      }

      

    }

    std::vector<bool> getFeatureMask(size_t n){
      
      int totaldim=6;

      std::vector<bool> ret(totaldim,false);

      // currently hard-coded

      switch(n){
      case 0:
	for(size_t d=0;d<6;d++)
	  ret[d] = true;
	break;
//       case 1:
// 	for(size_t d=4;d<12;d++)
// 	  ret[d] = true;
// 	break;
//       case 2:
// 	for(size_t d=0;d<6;d++)
// 	  ret[d] = true;
// 	break;
/*       case 3: */
/* 	for(size_t d=0;d<3;d++) */
/* 	  ret[d] = true; */
/* 	for(size_t d=9;d<10;d++) */
/* 	  ret[d] = true; */
/* 	break; */
/*       case 4: */
/* 	for(size_t d=9;d<10;d++) */
/* 	  ret[d] = true; */
/* 	break; */
/*       case 1: */
/* 	for(size_t d=3;d<6;d++) */
/* 	  ret[d] = true; */
/* 	break; */
/*       case 2: */
/* 	for(size_t d=0;d<6;d++) */
/* 	  ret[d] = true; */
/* 	break; */

      }

      return ret;
      
    }

  };
}
#endif
