#ifndef SLMOTION_GRAPHICAL_STRING_SHEET
#define SLMOTION_GRAPHICAL_STRING_SHEET

#ifdef SLMOTION_WITH_GTK
#include <gtk/gtk.h>
#include <string>
#include <vector>

namespace slmotion {
  namespace gui {
    /**
     * This class represents a spreadsheet-like graphical element with
     * named columns of string rows
     */
    class GraphicalStringSheet {
    public:
      GraphicalStringSheet();

      inline GtkWidget* toGtkWidget() {
        return scrolledWindow;
      }

      inline GtkTreeView* toGtkTreeView() {
        return treeView;
      }

      /**
       * Adds a column with the specified name.
       *
       * @return A 0-based column index
       */
      int addColumn(const std::string& name);



      /**
       * Adds a row to the sheet. The number of entries in the text
       * vector should correspond to the number of columns.
       */
      void addRow(const std::vector<std::string>& text);



      /**
       * Creates the model; the structure is frozen so that no more
       * columns can be added. However, no actual content can be added
       * before the model is created.
       */
      void createModel();



    private:
      GtkWidget* scrolledWindow;
      GtkTreeView* treeView;
      int nColumns;
      GtkListStore* model;
    };
  }
}

#endif // SLMOTION_WITH_GTK
#endif
