#ifndef SLMOTION_HAND_EVALUATOR
#define SLMOTION_HAND_EVALUATOR

#include "HandFitter.hpp"

namespace slmotion {

  /**
   * Attempts to locate the bounding box of the hand on the basis of
   * skin blobs detected
   */
  class HandEvaluator : public Component {
  public:
    HandEvaluator(bool) : Component(true) { }

    HandEvaluator(BlackBoard* blackBoard, FrameSource* frameSource) :
      Component(blackBoard, frameSource),
      trimmedThreshold(1.0),
      trimmedMaxSize(INT_MAX),
      phogLevels(3),
      phogBins(20),
      cannyThreshold(100)
    { }

    virtual void process(frame_number_t frameNumber);

    virtual std::string getShortDescription() const {
      return "Hand Evaluator";
    }

    virtual std::string getLongDescription() const {
      return "Evaluates if there is "
        "some level of similarity between the input image and the given "
        "abstract hand configuration.";
    }

    virtual property_set_t getRequirements() const {
      return property_set_t { HAND_FITTER_RENDERED_IMG_ENTRY,
          HAND_FITTER_HAND_BOX_IMG_ENTRY,
          HAND_FITTER_HAND_BOX_BINARY_IMG_ENTRY
          };
    }

    virtual property_set_t getProvided() const {
      return property_set_t();
    }

    virtual std::string getShortName() const {
      return "HandEvaluator";
    }

    virtual std::string getComponentName() const {
      return "Hand Evaluator";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const;

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  private:
virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;



    double trimmedThreshold; // threshold for trimmed hog
    size_t trimmedMaxSize;
    size_t phogLevels;
    size_t phogBins;
    double cannyThreshold;
  };
}

#endif

