#include "HandVisualiser.hpp"
#include "util.hpp"

namespace slmotion {
#ifdef SLMOTION_ENABLE_LIBHAND
  std::string HandVisualiser::getDefaultSceneSpec() {
    return getInstallPrefix() + "/share/slmotion/scene_spec.yml";
  } 

  void HandVisualiser::init(const std::string& sceneSpecStr, const cv::Size& frameSize) {
    if (frameSize == cv::Size(0,0))
      renderer.Setup();
    else
      renderer.Setup(frameSize.width, frameSize.height);
    sceneSpec = libhand::SceneSpec(sceneSpecStr);
    renderer.LoadScene(sceneSpec);
    bogusHandPose = libhand::FullHandPose(sceneSpec.num_bones());
  }

  cv::Mat HandVisualiser::render(const libhand::FullHandPose& pose, 
                                 double r, double theta, double phi, 
                                 double tilt, int tx, int ty) {

    libhand::HandCameraSpec cameraSpec = renderer.camera_spec();
    cameraSpec.r = r;
    cameraSpec.theta = theta;
    cameraSpec.phi = phi;
    cameraSpec.tilt = tilt;
    renderer.set_camera_spec(cameraSpec);
    renderer.SetHandPose(pose);
    renderer.RenderHand();
    return translate(renderer.pixel_buffer_cv(), tx, ty);
  }
#endif
}
