#include "HeadPose.hpp"

namespace slmotion {
  static HeadPose DUMMY(true);

  void HeadPose::process(frame_number_t frameNumber) {
    getBlackBoard().set(frameNumber, HEAD_POSE_BLACKBOARD_ENTRY, cv::Vec3d(1,2,3));
  }

  Component* HeadPose::createComponentImpl(const boost::program_options::variables_map&, BlackBoard* blackBoard, FrameSource* frameSource) const {
    return new HeadPose(blackBoard, frameSource);
  }
}
