#ifndef SLMOTION_IMAGESEQUENCESOURCE
#define SLMOTION_IMAGESEQUENCESOURCE
#include "FrameSource.hpp"


namespace slmotion {
  /**
   * This class takes in a sequence of image filenames, and then retrieves them 
   * in the given order, as if in a video
   */
  class ImageSequenceSource : public FrameSource {
  public:
    /**
     * The default constructor. Creates a copy of the filenames vector, and
     * stores it internally.
     *
     * @param filenames Image filenames
     * @param cacheSize Maximum size allowed for the cache.
     */
    ImageSequenceSource(const std::vector<std::string>& filenames,
                        double fps = 25,
                        size_t cacheSize = SIZE_MAX) :
      FrameSource(cacheSize), filenames(filenames), fps(fps) {}


    /**
     * @param filenames Image filenames
     */
    explicit ImageSequenceSource(std::vector<std::string>&& filenames,
                                 double fps = 25,
                                 size_t cacheSize = SIZE_MAX) :
      FrameSource(cacheSize), filenames(std::move(filenames)), fps(fps) {
    }



    /**
     * The default destructor, implemented because of necessity
     */
    ~ImageSequenceSource() {}


    /**
     *
     */
    inline frame_number_type size() const {
      return filenames.size();
    }


    /**
     *
     */
    const cv::Mat& operator[](frame_number_type frameNumber);


    /**
     *
     */
    const std::string& getFileName() const {
      if (current_file_number >= filenames.size())
	throw std::out_of_range("Tried to access a filename beyond limits");
      return filenames[current_file_number];
    }



    virtual double getFps() const {
      return fps;
    }

  private:
    cv::Mat getFrame(frame_number_type);

    std::vector<std::string> filenames;

    size_t current_file_number;
    double fps;
  };
}
#endif
