#ifndef SLMOTION_INTERPRETATION_RESULT
#define SLMOTION_INTERPRETATION_RESULT

#include "BodyPart.hpp"

namespace slmotion {
  /**
   * Results as produced by the postprocessing function below
   */
  struct InterpretationResult {
    std::deque < std::vector<double> > fullMotionDescriptors; ///< All motion descriptors for each frame

    // features below are primarily for visualisation purposes
    std::deque < std::vector<cv::Point2f> > lkMotionVectors; ///< Motion vectors for each frame (Lucas-Kanade)
    std::deque < std::vector<cv::Point2f> > lkAccelerationVectors; ///< Acceleration vectors for each frame (Lucas-Kanade)
    std::deque < std::vector<bool> > lkGoodFeatures; ///< Feature is good if it has been tracked over three consequent frames (Lucas-Kanade)
    std::deque < std::vector<BodyPart::PartName> > lkFeatureIdentities;
  };
}

#endif

