#include "LinePointIterator.hpp"

namespace slmotion {
  LinePointIterator::LinePointIterator(const cv::Point& startPoint,
                      const cv::Point& endPoint) :
    startPoint(startPoint), endPoint(endPoint), currentPoint(startPoint),
    dx(std::abs(endPoint.x-startPoint.x)), 
    dy(std::abs(endPoint.y-startPoint.y)),
    sx(startPoint.x < endPoint.x ? 1 : -1),
    sy(startPoint.y < endPoint.y ? 1 : -1),
    err(dx-dy)
    {    
    }

  

  LinePointIterator& LinePointIterator::operator++() {
    if (currentPoint != endPoint) {
      int e2 = 2*err;
      if (e2 > -dy) {
        err -= dy;
        currentPoint.x += sx;
      }
      
      if (e2 < dx) {
        err += dx;
        currentPoint.y += sy;
      }
    }
    return *this;
  }
}
