#ifdef SLMOTION_ENABLE_LIBFLANDMARK
#ifndef SLMOTION_MULTI_FACIAL_LANDMARK_DETECTOR
#define SLMOTION_MULTI_FACIAL_LANDMARK_DETECTOR

#include "FacialLandmarkDetector.hpp"

namespace slmotion {
  // a vector of vectors of point2fs; storing the facial landmarks of the corresponding faces
  const std::string MULTI_FACIAL_LANDMARK_BLACKBOARD_ENTRY = "multifaciallandmarksvector";

  class MultiFacialLandmarkDetector : public FacialLandmarkDetector {
  public:
    MultiFacialLandmarkDetector(bool) : FacialLandmarkDetector(true) { }

    MultiFacialLandmarkDetector(BlackBoard* blackBoard, 
                                FrameSource* frameSource) :
      FacialLandmarkDetector(blackBoard, frameSource)
    { }

    MultiFacialLandmarkDetector(const MultiFacialLandmarkDetector& other) = delete;
    FacialLandmarkDetector& operator=(const FacialLandmarkDetector&) = delete;
    virtual ~MultiFacialLandmarkDetector(); 

    virtual void process(frame_number_t frameNumber);

    virtual std::string getShortDescription() const {
      return "Multiple Facial landmark detector";
    }

    virtual std::string getLongDescription() const {
      return "Multiple Facial landmark detector";
    }

    virtual property_set_t getRequirements() const;

    virtual property_set_t getProvided() const;

    virtual std::string getShortName() const {
      return "MultiFacialLandmarkDetector";
    }

    virtual std::string getComponentName() const {
      return "Multiple Facial Landmark Detector";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const {
      return boost::program_options::options_description();
    }

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  private:
    virtual bool processRangeImplementation(frame_number_t first, 
                                            frame_number_t last, 
                                            UiCallback* uiCallback) {
      return Component::processRangeImplementation(first, last, uiCallback);
    }



    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;
  };
}

#endif // SLMOTION_MULTI_FACIAL_LANDMARK_DETECTOR
#endif // SLMOTION_ENABLE_LIBFLANDMARK
