#ifndef SLMOTION_NAIVE_BAYES_CLASSIFIER
#define SLMOTION_NAIVE_BAYES_CLASSIFIER

#include "BinaryClassifier.hpp"
#include <opencv2/opencv.hpp>

namespace slmotion {
  class NaiveBayesClassifier : public BinaryClassifier {

  public:


    NaiveBayesClassifier(){
      components=std::vector<size_t>(2,1); // default is one mixture component
                                      // for both classes 
    }

    virtual void train(const std::vector<std::vector<float> > &negSamples,
		       const std::vector<std::vector<float> > &posSamples,
		       const std::vector<bool> *dimMask=NULL,
		       const std::vector<float> *negWeights=NULL,
		       const std::vector<float> *posWeights=NULL);

    virtual float predict(const std::vector<float>  &sample,
			  const std::vector<bool> *dimMask=NULL);

    std::vector<size_t> components;

    float aprioriprob; // a priori probability of class 1

    std::vector<std::vector<cv::Mat> > inverseCovariances; /// Inverse covariance matrices
    std::vector<std::vector<cv::Mat> > means; ///< Colour cluster means
    std::vector<std::vector<double> > covDetSqrt; ///< Square roots of covariance matrix determinants

    std::vector<std::vector<double> > componentWeights;

    std::map<std::vector<float>,float> predictioncache;
  };
}
#endif
