#include "OpenCVVideoCaptureVideoFileSource.hpp"

#ifdef SLMOTION_THREADING
#include <thread>
#endif



using cv::Mat;



namespace slmotion {
  extern bool paranoid;

  OpenCVVideoCaptureVideoFileSource::frame_number_type OpenCVVideoCaptureVideoFileSource::size() const {
#ifdef SLMOTION_THREADING
    std::lock_guard<std::mutex> lock(this->mutex);
#endif
    if (totalNumberOfFrames == SIZE_MAX) {
      if (paranoid) {
        cv::VideoCapture vc(filename);
        totalNumberOfFrames = 0;
        while(vc.grab()) 
          ++totalNumberOfFrames;
      }
      else
        totalNumberOfFrames = capture.get(CV_CAP_PROP_FRAME_COUNT);
    }
    return totalNumberOfFrames;
  }



  Mat OpenCVVideoCaptureVideoFileSource::getFrame() {
#ifdef SLMOTION_THREADING
    std::lock_guard<std::mutex> lock(this->mutex);
#endif
    Mat temp;
    capture >> temp;
    assert(!temp.empty());
    return temp.clone(); // must return a deep copy
  }

  // OpenCVVideoCaptureVideoFileSource::OpenCVVideoCaptureVideoFileSource() {
  // }

  OpenCVVideoCaptureVideoFileSource::OpenCVVideoCaptureVideoFileSource(const std::string& filename,
                                                                       size_t cacheSize) :
  VideoFileSource(filename, cacheSize) {
    this->capture = cv::VideoCapture(filename);
    this->filename = filename;
    this->totalNumberOfFrames = SIZE_MAX;
    if(!capture.isOpened())
      throw SLIOException("Could not open video file.");
  }



  double OpenCVVideoCaptureVideoFileSource::getFps() const {
    return capture.get(CV_CAP_PROP_FPS);
  }
}
