#ifndef SLMOTION_OPENCV_VIDEOFILESOURCE
#define SLMOTION_OPENCV_VIDEOFILESOURCE

#include <memory>
#include "VideoFileSource.hpp"
#include "SLIO.hpp"


namespace slmotion {
  /**
   * This class serves as a backend for the VideoFileSource class. The class
   * uses the OpenCV VideoCapture class.
   *
   * An internal frame number is stored, since videos are usually accessed
   * sequentially, and, because of this, the fastest way to read the video
   * would be through sequential access.
   *
   * However, OpenCV also provides a cumbersome interface to access any 
   * given frame, which will be used whenever the requested frame number 
   * does not match the current internal frame number.
   */
  class OpenCVVideoCaptureVideoFileSource : public VideoFileSource {
  public:
    OpenCVVideoCaptureVideoFileSource(const std::string& filename, size_t cacheSize = SIZE_MAX);
    


    /**
     * The default destructor, implemented because of necessity
     */
    ~OpenCVVideoCaptureVideoFileSource() {}



    frame_number_type size() const;



    virtual double getFps() const;



  private:
    cv::Mat getFrame();



    inline void reset(const std::string& filename) {
      capture = cv::VideoCapture(filename);
    }



    mutable cv::VideoCapture capture;
    size_t currentFrameNumber;
    std::string filename;
    mutable size_t totalNumberOfFrames; ///< Total number of frames (used in paranoia mode)

#ifdef SLMOTION_THREADING
    mutable std::mutex mutex; ///< If threaded access is used, this object will be used for mutual exclusion
#endif
  };
}
#endif
