#ifndef SLMOTION_POAANNOTATIONAID
#define SLMOTION_POAANNOTATIONAID

#include "Component.hpp"
#include "PropagationSkinDetector.hpp"

// This is a dummy component file that can be used as a template for 
// creating actual useful components

namespace slmotion {
  class POAAnnotationAid : public Component {
  public:
    POAAnnotationAid(bool) : Component(true) { }

    POAAnnotationAid(BlackBoard* blackBoard, FrameSource* frameSource) :
      Component(blackBoard, frameSource) { }

    virtual void process(frame_number_t /* frameNumber */){
      throw std::string("Processing of individual frames not supported"); 
    }

    bool processRangeImplementation(frame_number_t first,
                                    frame_number_t last,
                                    UiCallback* uiCallback);


    virtual std::string getShortDescription() const {
      return "Another testing component for Ville";
    }

    virtual std::string getLongDescription() const {
      return "Dummy configuration file help text";
    }

    virtual property_set_t getRequirements() const {
      return property_set_t {};
    }

    virtual property_set_t getProvided() const {
      return property_set_t();
    }

    virtual std::string getShortName() const {
      return "POAAnnotationAid";
    }

    virtual std::string getComponentName() const {
      return "POAAnnotationAid for testing ideas on template match based head point tracking that doen't rely on skin detection results";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const {
      return boost::program_options::options_description();
    }

 virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }


  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;
  };


 
}

#endif

