#ifndef SLMOTION_PYTHON_COMPONENT
#define SLMOTION_PYTHON_COMPONENT

#include "Component.hpp"
#include <boost/python.hpp>

namespace slmotion {
  /**
   * This class represents a meta-component that passes the execution
   * to the python class where the actual magic happens
   */
  class PythonComponent : public Component {
  public:
    PythonComponent(bool) : Component(true) { }

    PythonComponent(BlackBoard* blackBoard, FrameSource* frameSource) :
      Component(blackBoard, frameSource) { }

    PythonComponent(const PythonComponent&) = default;
    PythonComponent& operator=(const PythonComponent&) = default;

    virtual void process(frame_number_t frameNumber);

    virtual std::string getShortDescription() const;

    virtual std::string getLongDescription() const;

    virtual property_set_t getRequirements() const;

    virtual property_set_t getProvided() const;

    virtual std::string getShortName() const;

    virtual std::string getComponentName() const;

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const;

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  private:
    bool processRangeImplementation(frame_number_t first,
                                    frame_number_t last,
                                    UiCallback* uiCallback);

    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;
    
    std::string className; ///< Python component class name
    boost::python::object instance; ///< python object
  };
}

#endif

