#!/usr/bin/python

import slmotion
import cv2
import time

# this is an example of a component that has been implemented in Python

class PythonExampleComponent(slmotion.PythonComponentBase):
    BLACKBOARD_ENTRY_NAME = 'PythonExampleEntry'

    def __init__(self, opts):
        slmotion.PythonComponentBase.__init__(self)
        if 'multiplier' in opts:
            self._multiplier = opts['multiplier']
        else:
            self._multiplier = 1

        if 'addend' in opts:
            self._addend = opts['addend']
        else:
            self._addend = 0

    # convert to greyscale, multiply, and add
    # then store the entry
    def process(self, frameNumber):
        inframe = slmotion.framesource[frameNumber]
        gsimg = cv2.cvtColor(inframe, cv2.COLOR_BGR2GRAY) / 255.
        result = gsimg*self._multiplier + self._addend
        slmotion.blackboard.set(result, self.BLACKBOARD_ENTRY_NAME, frameNumber,
                                slmotion.BlackBoard.NONE)

    # Either process() or processRange() must be implemented, but it
    # is not mandatory to implement both. In this case, we are talking
    # about a simple Python equivalent of the default processRange()
    # implementation.
    def processRange(self, firstFrame, lastFrame):
        for f in range(firstFrame, lastFrame):
            self.process(f)
            if self.callback(100.*f/(lastFrame-firstFrame)) == False:
                return False
        return True

    def getShortDescription(self):
        return 'A simple Python example'

    def getLongDescription(self):
        return ('A simple Python example that just converts the input frame '
                'into a grayscale image, and then multiplies it by a multiplier '
                'and adds a constant.')

    def getRequirements(self):
        return set()

    def getProvided(self):
        return {self.BLACKBOARD_ENTRY_NAME}

    def getShortName(self):
        return 'PythonExampleComponent'

    def getComponentName(self):
        return 'Python Example Component'
