#ifndef SLMOTION_PYTHON_NOT_IMPLEMENTED_EXCEPTION
#define SLMOTION_PYTHON_NOT_IMPLEMENTED_EXCEPTION

#include "PythonException.hpp"

namespace slmotion {
  namespace python {
    /**
     * This class is simply supposed to act as a C++ equivalent of the
     * Python's not implemented error.
     */
    class PythonNotImplementedException : public PythonException {
    public:
      explicit PythonNotImplementedException(const char* msg) :
      PythonException(msg)
      {}
      
      
      
      explicit PythonNotImplementedException(const std::string& msg) :
        PythonException(msg.c_str())
      {}
      

      
      virtual ~PythonNotImplementedException() throw() {}



      inline static void translate(const PythonNotImplementedException& e) {
        PyErr_SetString(PyExc_NotImplementedError, e.what());
      }
    };
  }
}

#endif
