#ifndef SLMOTION_EXCEPTION
#define SLMOTION_EXCEPTION

#include <exception>
#include <cstring>

namespace slmotion {
  /**
   * A base class for exceptions thrown by any component in this program. 
   * All exceptions are basically the same, so this provides the implementation.
   * Most actual derived exception classes are just 'aliases' for this class.
   */
  class SLMotionException : public std::exception {
  public:
    /**
     * Returns the associated message
     *
     * @return The associated message as a C string
     */
    virtual const char* what() const throw() {
      return msg;
    }



    /**
     * A dummy destructor
     */
    virtual ~SLMotionException() throw() {
    }



    /**
     * Constructs the exception
     *
     * @param message An explanatory message
     */
    explicit SLMotionException(const char* message) {
      strncpy(msg, message, 1023);
      msg[1023] = '\0';
    }



    /**
     * A simple copy-constructor
     *
     * @param e RHS parameter
     */
    SLMotionException(const SLMotionException& e) throw() {
      strncpy(msg, e.msg, 1023);
      msg[1023] = '\0';
    }



    /**
     * Simple assignment. Creates a deep copy.
     *
     * @param e The source
     *
     * @return A reference to the target (left-hand side)
     */
    SLMotionException& operator= (const SLMotionException& e) throw() {
      strncpy(msg, e.msg, 1023);
      msg[1023] = '\0';
      return *this;
    }


    
  private:
    char msg[1024]; ///< The message
  };
}
#endif
