#include "TemporalSkinPropagator.hpp"

using cv::Mat;
using std::endl;
using std::cerr;

namespace slmotion {
  extern int debug;



  void TemporalSkinPropagator::process(frame_number_t) {
    assert(false && "This component does not do per-frame processing.");
  }



  bool TemporalSkinPropagator::processRangeImplementation(frame_number_t first, frame_number_t last, UiCallback* uiCallback) {
    size_t frnumber = first;
    Mat frame;

    size_t firstframe=first;
    size_t lastframe=last > 0 ? last-1 : 0;

    // from the first frame, determine the colour stdev between two 
    // adjacent (8-connectivity) skin pixels

    // cv::Mat f=*boost::any_cast<cv::Mat>(&blackboard[std::pair<int,std::string>(firstframe,"frame")]);
    cv::Mat f=getFrameSource()[firstframe];

    // cv::Mat m=*boost::any_cast<cv::Mat>(&blackboard[std::pair<int,std::string>(firstframe,"skinmask")]);
    BlackBoardPointer<cv::Mat> mPtr = getBlackBoard().get<cv::Mat>(firstframe,"skinmask");
    cv::Mat m=*mPtr;

    float dsum=0,dsqrsum=0;
    size_t dcount=0;

    if (slmotion::debug > 1) {
      cerr << "frame size is " << f.cols << "x"<<f.rows<<endl;
    }

    // for convenience, ignore some border pixels of the matrix

    for(int i = 1; i < f.rows-1; i++)
      for(int j = 0; j < f.cols-1; j++){
        if(m.at<uchar>(i,j)){
          if(m.at<uchar>(i+1,j)){
            cv::Vec3b diff=f.at<cv::Vec3b>(i,j)-f.at<cv::Vec3b>(i+1,j);
            float d=sqrt(diff.dot(diff));
            dsum += d;
            dsqrsum += d*d;
            dcount++;
          }

          if(m.at<uchar>(i-1,j+1)){
            cv::Vec3b diff=f.at<cv::Vec3b>(i,j)-f.at<cv::Vec3b>(i-1,j+1);
            float d=sqrt(diff.dot(diff));
            dsum += d;
            dsqrsum += d*d;
            dcount++;
          }

          if(m.at<uchar>(i,j+1)){
            cv::Vec3b diff=f.at<cv::Vec3b>(i,j)-f.at<cv::Vec3b>(i,j+1);
            float d=sqrt(diff.dot(diff));
            dsum += d;
            dsqrsum += d*d;
            dcount++;
          }

          if(m.at<uchar>(i+1,j+1)){
            cv::Vec3b diff=f.at<cv::Vec3b>(i,j)-f.at<cv::Vec3b>(i+1,j+1);
            float d=sqrt(diff.dot(diff));
            dsum += d;
            dsqrsum += d*d;
            dcount++;
          }

        }
      }

    dsum /= dcount;
    dsqrsum /= dcount;

    float dstdev=sqrt(dsqrsum-dsum*dsum);


    if (slmotion::debug > 1){
      cerr << "Estimated the between-skin-pixel std "<<dstdev << endl;
      cerr << "from " << dcount << " pixel pairs" << endl;
    }

    // now propagate detected skin pixels temporally if pixel intensity 
    // stays about constant

    size_t changecount;

    do {

      changecount=0;

      // forward pass

      cv::Mat frame,prevframe,mask,prevmask;

      // prevframe=*boost::any_cast<cv::Mat>(&blackboard[std::pair<int,std::string>(firstframe,"frame")]);
      prevframe=getFrameSource()[firstframe];
      // prevmask=*boost::any_cast<cv::Mat>(&blackboard[std::pair<int,std::string>(firstframe,"skinmask")]);
      BlackBoardPointer<cv::Mat> prevmaskPtr = getBlackBoard().get<cv::Mat>(firstframe,"skinmask");
      prevmask=*prevmaskPtr;

      for(frnumber=firstframe+1;frnumber<=lastframe;frnumber++) {

        // frame=*boost::any_cast<cv::Mat>(&blackboard[std::pair<int,std::string>(frnumber,"frame")]);
        // mask=*boost::any_cast<cv::Mat>(&blackboard[std::pair<int,std::string>(frnumber,"skinmask")]);
        frame=getFrameSource()[frnumber];
        BlackBoardPointer<cv::Mat> maskPtr = getBlackBoard().get<cv::Mat>(frnumber,"skinmask");
        mask=*maskPtr;

        for(int i = 0; i < frame.rows; i++)
          for(int j = 0; j < frame.cols; j++){

            if(prevmask.at<uchar>(i,j)>0 && mask.at<uchar>(i,j)==0){

              // previous frame contains skin in this 
              // location but this frame not

              // 
              cv::Vec3b diff=frame.at<cv::Vec3b>(i,j)
                -prevframe.at<cv::Vec3b>(i,j);

              float d=sqrt(diff.dot(diff));
	       
              //		 cerr << "candidate for propagation: d=" << d << endl;
              //	       cerr << "prev pixel: (" << (*pfit)[0] << " "<<(*pfit)[1]<<" "<<(*pfit)[2]<<")" << endl;
              //	       cerr << "current pixel: (" << (*fit)[0] << " "<<(*fit)[1]<<" "<<(*fit)[2]<<")" << endl;
	       
              if(d<dstdev){
                mask.at<uchar>(i,j)= prevmask.at<uchar>(i,j);
                changecount++;
              }
            }
          }
	   
        prevframe=frame;
        prevmask=mask;

        if (uiCallback != NULL && !(*uiCallback)(frnumber))
          return false;
      }
      if (slmotion::debug > 1)
        cerr << changecount << "new skin pixels found in forward pass " << endl;

      // backward pass

      for(frnumber=lastframe-1;frnumber<=firstframe;frnumber--) {

        // frame=*boost::any_cast<cv::Mat>(&blackboard[std::pair<int,std::string>(frnumber,"frame")]);
        // mask=*boost::any_cast<cv::Mat>(&blackboard[std::pair<int,std::string>(frnumber,"skinmask")]);

        frame=getFrameSource()[frnumber];
        BlackBoardPointer<cv::Mat> maskPtr = getBlackBoard().get<Mat>(frnumber,"skinmask");
        mask=*maskPtr;


        for(int i = 0; i < frame.rows; i++)
          for(int j = 0; j < frame.cols; j++){

            if(prevmask.at<uchar>(i,j)>0 && mask.at<uchar>(i,j)==0){

              // previous frame contains skin in this 
              // location but this frame not

              // 
              cv::Vec3b diff=frame.at<cv::Vec3b>(i,j)
                -prevframe.at<cv::Vec3b>(i,j);

              float d=sqrt(diff.dot(diff));
	       
              //		 cerr << "candidate for propagation: d=" << d << endl;
              //	       cerr << "prev pixel: (" << (*pfit)[0] << " "<<(*pfit)[1]<<" "<<(*pfit)[2]<<")" << endl;
              //	       cerr << "current pixel: (" << (*fit)[0] << " "<<(*fit)[1]<<" "<<(*fit)[2]<<")" << endl;
	       
              if(d<dstdev){
                mask.at<uchar>(i,j)= prevmask.at<uchar>(i,j);
                changecount++;
              }
            }
          }
	   
        prevframe=frame;
        prevmask=mask;

        if (uiCallback != NULL && !(*uiCallback)(frnumber))
          return false;
      }

      if (slmotion::debug > 1)
        cerr << changecount << "new skin pixels in total after backward pass " << endl;
    } while (changecount>0);

    return true;
  }
}
