#include "ThresholdSkinDetector.hpp"
#include "util.hpp"

namespace slmotion {
  void ThresholdSkinDetector::detect(const cv::Mat& inFrame, cv::Mat& outMask) {
    // example rules (from Peer et al. 2003, not sure if they are any good,
    // they seem to make some sense)

    assert(inFrame.type() == CV_8UC3);
    assert(inFrame.size() == outMask.size());
    assert(outMask.type() == CV_8UC1);

    inRange(inFrame, lowerb, upperb, outMask);
  }



  Component* ThresholdSkinDetector::createComponentImpl(const boost::program_options::variables_map&, BlackBoard* blackBoard, FrameSource* frameSource) const {
    return new ThresholdSkinDetector(blackBoard, frameSource);
  }
}

