#ifndef SLMOTION_THRESHOLD_SKIN_DETECTOR
#define SLMOTION_THRESHOLD_SKIN_DETECTOR

#include "SkinDetector.hpp"

namespace slmotion {
  /**
   * A simple implementation of the skin detector interface. Detects skin
   * regions using simple thresholds for pixel values.
   */
  class ThresholdSkinDetector : public SkinDetector {
  public:
    /**
     * Creates a detector. Uses some default rules to achieve the
     * desired results.
     *
     * @param c Colour space to use. RGB by default.
     */
    explicit ThresholdSkinDetector(BlackBoard* blackBoard, 
                                   FrameSource* frameSource,
                                   const ColourSpace& c = *ColourSpace::RGB) :
      SkinDetector(blackBoard, frameSource, c) {}

    /**
     * Sets manual thresholds. Each element in the Scalar represents the
     * corresponding colour channel number. The first value of lowerb is
     * the lower bound, and the value upperb is the corresponding upper bound
     * so that for each element e_i(x,y) in the output mask (where x, y are
     * coordinates and i is the channel number), it holds that
     * lowerb[i] <= e_i(x,y) < upperb[i]
     *
     * @param lowerb Lower bounds
     * @param upperb Upper bounds
     * @param c Colour space
     */
    explicit ThresholdSkinDetector(BlackBoard* blackBoard, 
                                   FrameSource* frameSource,
                                   const cv::Scalar& lowerb,
                                   const cv::Scalar& upperb,
                                   const ColourSpace& c = *ColourSpace::RGB) :
      SkinDetector(blackBoard, frameSource, c), lowerb(lowerb), 
      upperb(upperb) { 
    }



    /*
    std::string findParameters(const cv::Mat& validImage,
                               const cv::Mat& validMask, double fpCost = 1, 
                               double fnCost = 1) {
    */
    std::string findParameters(const cv::Mat&, const cv::Mat&, double = 1,
                               double = 1) {

      assert(false); // not implemented, this is here to catch attention
    }



    virtual std::string getShortDescription() const {
      return "A simple skin detector based on thresholding pixel values.";
    }

    virtual std::string getLongDescription() const {
      return "A simple skin detector based on thresholding pixel values.";
    }

    virtual property_set_t getRequirements() const {
      return property_set_t();
    }

    virtual std::string getShortName() const {
      return "ThresholdSkinDetector";
    }

    virtual std::string getComponentName() const {
      return "Threshold Skin Detector";
    }
    
    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }


  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;



    void detect(const cv::Mat& inFrame, cv::Mat& outMask);

    cv::Scalar lowerb; ///< Lower bounds, per component
    cv::Scalar upperb; ///< Upper bounds, per component
  };
}
#endif
