#ifndef SLMOTION_TRACKING_SKIN_DETECTOR
#define SLMOTION_TRACKING_SKIN_DETECTOR

#include "SkinDetector.hpp"
#include "ELMClassifier.hpp"
#include "FeatureExtractor.hpp"

typedef std::map<std::pair<int,std::string>,boost::any> localBlackBoardType;

namespace slmotion {
  class TrackingSkinDetector : public SkinDetector {
  public:
    explicit TrackingSkinDetector(BlackBoard* blackBoard, 
                                  FrameSource* frameSource,
                                  const ColourSpace& c = *ColourSpace::HSV) :
      SkinDetector(blackBoard, frameSource, c)
    { 
      cls=NULL;
    }

    virtual ~TrackingSkinDetector(){
      delete cls;
    };

    void setOutputPrefix(const std::string &s){ outputprefix=s;}


  private:

    virtual void detect(const cv::Mat& /* inFrame*/,  cv::Mat& /*outMask*/);

     virtual bool processRangeImplementation(frame_number_t first, 
                                            frame_number_t last, 
					     UiCallback* uiCallback);

    void trackRange(int firstframe,int lastframe, bool trainColourModel);

    void extractHandBlobs(int firstframe,int lastframe,localBlackBoardType &bb);



    ELMClassifier *cls;
    FeatureExtractor fe;
    std::string outputprefix;
   
  };

void showOpticalFlow(int firstframe,int lastframe,localBlackBoardType &bb);
 void calcOpticalFlow(int firstframe,int lastframe,localBlackBoardType &bb,
		      std::string &tgtid);
  void showFeatureTracks(int firstframe,int lastframe,localBlackBoardType &bb);

  void fillHoles(cv::Mat &m);
  void labelConnectedComponents(cv::Mat &m,cv::Mat &lbl);
  int smallestCorresponding(int lbl,std::vector<int> corresp);
  void computeEdgeMagnitude(cv::Mat &src,cv::Mat &eimg);
  float findUpperQuantileFromFloatImage(cv::Mat &img, float quantile);
  void clusterSkinCount(cv::Mat &skincount, std::vector<cv::Point> &means);
  float sqrdist(cv::Point &p1, cv::Point &p2);
  void showDeterministicFalseColour32bit(const std::string &title, cv::Mat &src);
  void showDeterministicFalseColour8bit(const std::string &title, cv::Mat &src);

  void recordBlobProgression(int firstframe,int lastframe,localBlackBoardType &bb);
  void interpretBlobs(int firstframe,int lastframe,localBlackBoardType &bb);
  void extractIsolatedHands(int firstframe,int lastframe,localBlackBoardType &bb);

  void visualiseInterpretation(int firstframe,int lastframe,localBlackBoardType &bb,
			       const std::string &destination="");
  
  void writeFiles(const std::string &fnprefix,
		  cv::Mat frame,cv::Mat uniqueblobintmask, int lbl,
		  int minx, int miny, int maxx, int maxy,bool mirror);

  void snakeRefine(cv::Mat patch, cv::Mat mask);



  void removeSmallBlobs(cv::Mat &m, cv::Mat &mask, int minsize);




  class BlobInfo{
  public:
    int frame;
    int label;
    cv::Point seedpoint;
    std::set<int> overlappinglabels_prevframe;
    std::set<int> overlappinglabels_nextframe;

    void dump();

  };
    
  void updateMaskByTrackedPoints(cv::Mat &oldmask,cv::Mat &newmask,std::vector<cv::Point2f> &oldpoints, std::vector<cv::Point2f> &newpoints);

  void estimateSmoothMotionField(std::vector<cv::Point2f> &oldpoints, std::vector<cv::Point2f> 
				 &newpoints, cv::Mat &motionfield);

  void evaluateExtrapolatedMotionFieldAtPoints(std::vector<cv::Point2f> &oldpoints, std::vector<cv::Point2f> &newpoints, std::vector<cv::Point2f> &evalpoints,std::vector<cv::Point2f> &evalres,cv::Size imgsize);

  class BlobProgression{
  public:
    int firstframe;
    std::vector<std::vector<BlobInfo> > blobs;
    std::vector<std::map<int,int> > lbl2blobidx; // one map for each frame

    void dump(int frameidx);

  };

  class blobinterpretation_type{
  public:
    
    blobinterpretation_type(){
      uniquelabel=-1;

      isolated=false;
      face_overlap=false;

      left_hand=false;
      right_hand=false;
      head=false;
      
      isolated_hand_score=0;
      right_hand_score=0;
      left_hand_score=0;


    }

    int uniquelabel;

    bool isolated;
    bool face_overlap;

    // definite interpretation 
    // (value true is definite, false -> possibly unsure)

    bool left_hand;
    bool right_hand;
    bool head;

    // softer measurements

    float isolated_hand_score;
    
    float right_hand_score;
    float left_hand_score;

    void show(){
      std::cout << "uniquelabel: " << uniquelabel <<std::endl;
      std::cout << "isolated: " << isolated << std::endl; 

      std::cout << "face_overlap: " << face_overlap << std::endl; 

      std::cout << "left_hand: " << left_hand << std::endl; 
      std::cout << "right_hand: " << right_hand << std::endl; 
      std::cout << "head: " << head << std::endl; 

      std::cout << "isolated_hand_score: " << isolated_hand_score << std::endl; 
      std::cout << "right_hand_score: " << right_hand_score << std::endl; 
      std::cout << "left_hand_score: " << left_hand_score << std::endl; 
    }


  };

  struct gridpoint_type{
    int idx;

    int refx;
    int refy;

    int tgtx;
    int tgty;

    std::vector<int> nbr;
    std::vector<float> l0; // rest lengths of vertices

    void show(){
      std::cout << "idx= " << idx << " ref=("<<refx<<","<<refy<<")"<<std::endl;
      std::cout << "tgt=("<<tgtx<<","<<tgty<<")"<<std::endl;

      std::cout << "nbr="<<std::endl;
      for(auto it=nbr.begin();it!=nbr.end();it++)
	std::cout << " " << *it;
      std::cout << std::endl;

      std::cout << "l0="<<std::endl;
      for(auto it=l0.begin();it!=l0.end();it++)
	std::cout << " " << *it;
      std::cout << std::endl;

    }
  };

  typedef std::vector<gridpoint_type> grid_type;

  void set_l0(grid_type &g);

  void set_nbr_fullconnectivity(grid_type &g);

  void set_nbr_randomconnectivity(grid_type &g,int nbrcount);

  void init_grid(cv::Mat &mask, int spacing, std::vector<gridpoint_type> &grid);

  void init_grid_ntuple_full(cv::Mat &mask, int n, std::vector<gridpoint_type> &grid);

  void showgrid(cv::Mat &img, const std::vector<gridpoint_type> &grid,
		bool showref=true, bool showtgt=true, bool showlinks=true,
		bool showtgtlinks=false);

  void detectOccludedArea(int firstreferenceframe,
			  int firstocclusionframe,
			  int lastframe,
			  size_t nr_gridlets,
			  //  int isolatedheadlbl,
			  const std::string &constraintmaskid,
			  const std::string &unoccludedptid,
			  localBlackBoardType &bb, bool show=false);

 void detectOccludedArea(int firstframe,
			 int lastframe,
			 const std::string &salientpointid,
			 const std::string &constraintmaskid,
			 const std::string &unoccludedptid,
			 //			 const string &motionfieldid,
			 localBlackBoardType &bb,
			 bool show);

  // another version that uses gridlets among salient points for tracking

  

  void trackAreaWithGrid(int firstframe,int lastframe,
			 size_t nr_gridlets,
			 //int initiallbl,
			 const std::string &constraintmaskid,
			 //const std::string &unoccludedbkgndid,
			 const std::string &trackedptid,
			 localBlackBoardType &bb);


  void estimateMotionFieldbyGrid(cv::Mat &mask, cv::Mat &motionfield,int refframe, 
				 int tgtframe,std::map<int,cv::Mat> &intensityimages, 
				 cv::Mat &constraintmask_tgt, localBlackBoardType &bb);

// void initTrackByGridMotion(cv::Mat &mask, int refframe, int tgtframe, std::set<int> &constraintlbl, localBlackBoardType &bb, grid_type &grid,int initmode );

  void initTrackByMotionField(grid_type &grid,
			      cv::Mat & constraintmask, 
			      localBlackBoardType &bb,			
			      cv::Mat &motionfield,int initmode);

  void updateGridPointGreedyLocal(grid_type &grid,
				  int gind, cv::Mat &frif, cv::Mat &nextif,
				  cv::Mat &constraintmask,int templsize, int searchr,float alpha,
				  float power=2, float maxdist=0,bool show=false);

  float evaluateGridEnergy(grid_type &grid, bool include_matchenergy,
			   bool include_linkenergy, int idx, 
			   cv::Mat &fri, cv::Mat &nexti, 
			   int templater, float alpha);
  
  bool gridAnnealStepGlobalTranslation(grid_type &grid, 
				       cv::Mat &fri, cv::Mat &nexti, 
				       int templater, float alpha, float T,
				       cv::Mat &constraintmask);
  
  void updateGridGlobalpos(grid_type &grid, cv::Mat &frif, cv::Mat &nextif, 
			   int iter, float &T, float &bestE, grid_type &best_grid,
			   float leakfactor, float &wsum, 
			   float &acceptancesum,
			   float tgtaccprob,int templater,
			   float alpha,cv::Mat &constraintmask);

  void updateGridByGreedyLocal(grid_type & grid,cv::Mat &frif, cv::Mat &nextif,
			       cv::Mat &constraintmask,
			       int templater,int searchr,float alpha,
			      float &bestE, grid_type &best_grid);


  void spiralDeltas(std::vector<cv::Point> &v,int maxdev);

  int rand(int n);

  double randn();

  void placeConstraintMaskOnBlackboard(int frame,localBlackBoardType &bb,
				       const std::string &maskid,
				       const std::string &unique,
				       std::set<int> &constraintlbl);

  void placeFloatIntensityOnBlackboard(int frame,localBlackBoardType &bb);

  void ensurePaddedFramesOnBlackboard(int frame,localBlackBoardType &bb);

  void ensureIntensityOnBB_uchar(int frame,localBlackBoardType &bb);

  

  void constructFloatMaskFromPointCloud(int firstframe,int lastframe,const std::string &ptcloudid,
					const std::string &floatmaskid,localBlackBoardType &bb, bool show=false);

  void appendFrameToOutputVideo(cv::Mat &m, const std::string &outid, localBlackBoardType &bb);

  void writeOutputVideo(const std::string &outid, const std::string &filename, int fps, localBlackBoardType &bb);

  int findHeadBlobSize(int f, localBlackBoardType &bb);

  void selectSalientPointsOfMask(int f,
			       const std::string &maskid,
			       const std::string &pointsetid,
			       localBlackBoardType &bb);

  void matchingEnergyVsSet(int f, std::set<int> &pivotheadframes,
			   const std::string &pointsetid,
			   localBlackBoardType &bb);

  std::vector<float> matchingEnergyVsFrame(int f, int reff,
					   const std::string &pointsetid,
					   localBlackBoardType &bb);

  void correspondenceFieldByTemplateMatching(int refframe, int tgtframe,
					     int windowr, int spacing,
					     int maxdisplacement, cv::Point minpt, 
					     cv::Point maxpt,
					     cv::Mat &displacementfield,
					     cv::Mat &errorfield,
					     localBlackBoardType &bb);

  void correspondenceFieldByConstellationMatching(int refframe, int tgtframe,
						  const std::string &pointsetid,
						  const std::string &constraintmaskid,
						  cv::Mat &displacementfield,
						  cv::Mat &errorfield,
						  localBlackBoardType &bb);



  void calculateDiscontinuityEnergy(cv::Mat &dfield, cv::Mat &cmask,int r, cv::Mat &res);

  void recordHeadAreaCorrespondence(int first, int last, 
				 const std::string &maskid,
				 const std::string &displacementfieldid,
				 const std::string &errorfieldid,
				 const std::string &discontinuityfieldid,
				 const std::string &moderrorfieldid,
				 const std::string &interrorid,
				 const std::string &intdiscontinuityid,
				 const std::string &intmoderrorid,
				 localBlackBoardType &bb);

  void recordHeadAreaCorrespondenceByConstellations(int first, int last, 
				 const std::string &maskid,
				 const std::string &displacementfieldid,
				 const std::string &errorfieldid,
				 const std::string &discontinuityfieldid,
				 const std::string &moderrorfieldid,
				 const std::string &interrorid,
				 const std::string &intdiscontinuityid,
				 const std::string &intmoderrorid,
				 localBlackBoardType &bb);

  void trackNonfaceArea(int first,int last,
			const std::string &constraintmaskid,
			const std::string &nonfacemaskid,
			const std::string &salientpointid,
			const std::string &motionfieldid,
			const std::string &trackedpointid,
			localBlackBoardType &bb);

  void trackNonfaceAreaGridlet(int first,int last,
			       const std::string &constraintmaskid,
			       const std::string &nonfacemaskid,
			       const std::string &salientpointid,
			       const std::string &motionfieldid,
			       const std::string &trackedpointid,
			       localBlackBoardType &bb);

  void enumerateNtuplesAmongPoints(int f, const std::string &pointsetid,
				   int n, int maxdist,
				   std::vector<std::vector<cv::Point> > &res,
				   localBlackBoardType &bb);
  
  float trackGridletBetweenFrames(std::vector<cv::Point> &pt,int refframe, int tgtframe,
				  const std::string &constraintmaskid,
				  const std::string &motionfieldid,
				  bool posanneal,
				  std::vector<std::vector<cv::Point> > &additionalresults,
				  localBlackBoardType &bb,bool show=false);

  float trackSinglePointBetweenFrames(cv::Point &pt, std::vector<cv::Point> &res,
				      int refframe, int tgtframe,
				      const std::string &constraintmaskid,
				      const std::string &motionfieldid,
				      localBlackBoardType &bb);

  void approximateNNClassification(int f,std::vector<std::string> classptids, cv::Mat &mask, 
				   cv::Mat &res,
				   localBlackBoardType &bb);



  void purgeBlackboardFromFrames(int first,int last,localBlackBoardType &bb);


  void trackNonFaceGridlet(int srcframe, int tgtframe,localBlackBoardType &bb);

  void trackFaceGridlet(int srcframe, int tgtframe,localBlackBoardType &bb);

  void ensureUniqueBlobMaskOnBB(int f,localBlackBoardType &bb);

  void ensureMasksOnBB(int f,localBlackBoardType &bb);

  void ensureFaceRectOnBB(int f,localBlackBoardType &bb);

  void ensureFrameOnBB(int f,localBlackBoardType &bb);

  void ensureSalientPointsOnBB(int f,localBlackBoardType &bb);

  void ensureMotionFieldOnBB(int f,localBlackBoardType &bb);

  bool testIfOccluded(int f,localBlackBoardType &bb);

  bool testIfOccluded(int f, cv::Mat &ptmask, localBlackBoardType &bb);

  struct TrackingRecord{
    int referenceframe;
    std::vector<cv::Point> pt; // the coordinates in the reference frame
    float E;
    float E_threshold; // <0 signals that threshold has not yest been determined
    std::vector<float> referenceE;
  };

  void expandPointSetBySinglePointAnnealing(std::vector<cv::Point> &srcv,
					    std::vector<cv::Point> &resv,
					    int f, const std::string &cmaskid,
					    int accCount,float prob,
					    localBlackBoardType &bb);

  void interpolateLandmarksToBB(int first,int last,localBlackBoardType &bb);

  void findFaceMaskByLandmarks(int f,const std::string &cmaskid, localBlackBoardType &bb);

  void deleteNearbyGridletsFromTrackerState(int f,localBlackBoardType &bb);

  void deleteNonMaskGridletsFromTrackerState(int f, cv::Mat &dmask,localBlackBoardType bb);

  void expandMaskSequence(int first, int last, const std::string &srcid, 
			  const std::string &tgtid,
			  int spatialext, int temporalext, localBlackBoardType &bb);

  bool parseCommaSeparatedStringToList(const std::string &str, std::vector<std::string> &l);

  void showMotionField(cv::Mat &m);

  void trackNeighbourhoods(int first, int last, localBlackBoardType &bb);

  void selectRectanglesToTrack(int frame, int lbl, int nrRects, std::vector<cv::Rect> &result,
			       localBlackBoardType &bb);

  float trackRectangleBetweenFrames(cv::Rect &rect,int refframe, int tgtframe,
				    localBlackBoardType &bb,cv::Mat *cmask);
  
  float trackRectangleSetBetweenFrames(std::vector<cv::Rect> &rect,int refframe, int tgtframe,localBlackBoardType &bb, cv::Mat *cmask);

  void recordBlobTracks(int first, int last, localBlackBoardType &bb);

  void trackRectangleSet(std::vector<cv::Rect> &r,int reff, int tgtf, 
			 std::map<int,int> &trackercounts_ref,
			 localBlackBoardType &bb);

  void predictTrackerMotion(int id, int tgtframe, cv::Point2f &pos, 
			    float &dev,localBlackBoardType &bb);

  void dumpBlobTracks(std::map<int,std::vector<cv::Rect> > &bt);
 

}

#endif
