#ifndef SLMOTION_UICALLBACK
#define SLMOTION_UICALLBACK

#include <cstdlib>
#include <string>

namespace slmotion {
  /**
   * Since template and virtual functions do not mix, the users of 
   * components are expected to provide their callbacks by creating functors
   * inheriting from this class.
   */
  class UiCallback {
  public:
    typedef size_t frame_number_t;



    UiCallback() : currentComponentIndex(0), nComponents(0) {}

    
    void setCurrentComponentName(const std::string& name) {
      currentComponentName = name;
    }

    void setCurrentComponentIndex(size_t index) {
      currentComponentIndex = index;
    }

    virtual void setNComponents(size_t n) {
      nComponents = n;
    }

    /**
     * The callback wrapper. The implementation function should notify the
     * parent program of its status (current frame) if applicable. This
     * may also be ignored. If the callback function returns false, 
     * execution should be terminated prematurely.
     *
     * @return True if everything should continue as usual, false if 
     * immediate termination is requested.
     */
    virtual bool operator()(double percentComplete) = 0;
    virtual ~UiCallback() {}

    std::string getCurrentComponentName() const {
      return currentComponentName;
    }

    size_t getCurrentComponentIndex() const {
      return currentComponentIndex;
    }

    size_t getNComponents() const {
      return nComponents;
    }

  private:
    std::string currentComponentName;
    size_t currentComponentIndex;
    size_t nComponents;
  };
}
#endif
