#include "XmlDocument.hpp"
#include "exceptions.hpp"
#include "Validator.hpp"
#include <iostream>

namespace slmotion {
  namespace xml {
    void Validator::initialise() {
      // check the schema for validity
      // try {
      schemaCtxt = SchemaCtxtPtr(xmlSchemaNewDocParserCtxt(schemaDoc.internalDoc.get()),
                                 &xmlSchemaFreeParserCtxt);
      if (schemaCtxt.get() == NULL) 
        throw ConvertException("XML schema context could not be created."); 

      schema = SchemaPtr(xmlSchemaParse(schemaCtxt.get()),
                         &xmlSchemaFree);

      if (schema.get() == NULL) 
        throw ConvertException("Internal XML validation schema could not be created.");

      validatorCtxt = ValidatorCtxtPtr(xmlSchemaNewValidCtxt(schema.get()),
                                       &xmlSchemaFreeValidCtxt);

      if (validatorCtxt.get() == NULL) 
        throw ConvertException("XML validation context could not be created.");

      // }
      /*
        catch(...) {
        xmlSchemaFreeValidCtxt(validatorCtxt);
        xmlSchemaFree(schema);
        xmlSchemaFreeParserCtxt(schemaCtxt);
        xmlFreeDoc(schemaDoc);
        throw;
        }*/
    }



    Validator& Validator::operator=(Validator&& other) {
      if (this != &other) {
        std::swap(this->schemaDoc, other.schemaDoc);
        std::swap(this->schemaCtxt, other.schemaCtxt);
        std::swap(this->schema, other.schema);
        std::swap(this->validatorCtxt, other.validatorCtxt);
        std::swap(this->schemaFilename, other.schemaFilename);
      }
      return *this;
    }



    Validator::Validator(const std::string& filename) :
      schemaDoc(filename), 
      schemaCtxt((xmlSchemaParserCtxtPtr)NULL, &xmlSchemaFreeParserCtxt), 
      schema((xmlSchemaPtr)NULL, &xmlSchemaFree), 
      validatorCtxt((xmlSchemaValidCtxtPtr)NULL, &xmlSchemaFreeValidCtxt), 
      schemaFilename(filename) {
      if (schemaDoc.internalDoc.get() == NULL) 
        throw ConvertException("The schema file " + filename + " could not be read, or is invalid.");
      initialise();
    }

    static void DUMMYFUNCTION(void*, const char*, ...) {
    }

    bool Validator::validate(const XmlDocument& document) const {
      // prevent error messages from being printed to stdout
      xmlSchemaSetValidErrors(validatorCtxt.get(), 
                              DUMMYFUNCTION,
                              NULL, NULL);
      xmlSchemaSetValidOptions(validatorCtxt.get(), XML_SCHEMA_VAL_VC_I_CREATE);
      xmlSchemaValidCtxt* validatorCtxtPtr = validatorCtxt.get();
      xmlDoc* docPtr = document.internalDoc.get();
      bool response = xmlSchemaValidateDoc(validatorCtxtPtr, docPtr) == 0;
      return response;
    }
  }
}

