#ifndef SLMOTION_VISUAL_SILENCE_DETECTOR
#define SLMOTION_VISUAL_SILENCE_DETECTOR

#include "Component.hpp"

namespace slmotion {
  // a double value in range [0,1.0] where the lower the value, the less there is movement in the given frame
  const std::string VISUAL_SILENCE_BLACKBOARD_ENTRY = "visualsilence";

  /**
   * Attempts to detect "visual silence" (ie. non-motion) by computing
   * the difference images between the preceeding and the current
   * frame, and thresholding.
   */
  class VisualSilenceDetector : public Component {
  public:
    VisualSilenceDetector(bool) : Component(true) { }

    VisualSilenceDetector(BlackBoard* blackBoard, FrameSource* frameSource) :
      Component(blackBoard, frameSource), threshold(10) { }

    virtual void process(frame_number_t frameNumber);

    virtual std::string getShortDescription() const {
      return "Detects moments of non-motion";
    }

    virtual std::string getLongDescription() const {
      return "Detects moments of non-motion";
    }

    virtual property_set_t getRequirements() const {
      return property_set_t();
    }

    virtual property_set_t getProvided() const {
      return property_set_t { VISUAL_SILENCE_BLACKBOARD_ENTRY };
    }

    virtual std::string getShortName() const {
      return "VisualSilenceDetector";
    }

    virtual std::string getComponentName() const {
      return "Visual Silence Detector";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const;

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;
    bool processRangeImplementation(frame_number_t first, 
                                    frame_number_t last, 
                                    UiCallback* uiCallback);


    double threshold; ///< Threshold applied to the difference images
  };
}

#endif
