#include "SkinDetector.hpp"
#include "VviComponent.hpp"
#include "PropagationSkinDetector.hpp"
#include "TrackingSkinDetector.hpp"

using cv::Mat;
using cv::Rect;
using cv::Point;
using cv::Vec3b;
using cv::Scalar;
using cv::Point2f;
using std::string;
using std::map;
using std::set;
using std::cout;
using std::endl;
using std::pair;
using std::vector;

namespace slmotion {

  string outputprefix;

  static VviComponent DUMMY(true);

  bool VviComponent::processRangeImplementation(frame_number_t first,
				  frame_number_t last,
                                                UiCallback* /* uiCallback */){
    
    // cout << "vvicomponent processing frame range [" << first << 
    // "," << last << ")" << endl;
  
   //   cerr << "outputprefix="<<outputprefix<<endl;

   localBlackBoardType localbb; 

   // the blob progression analysis requires the following information to
   // be put on the local blackboard:

   // frames
   // skin detection mask
   // face detection results

   // old-fashioned blackboard for local info storage

   for(frame_number_t n=first;n<last;n++){
     // const cv::Mat& inFrame = getFrameSource()[n];
     // const cv::Mat& mask = getBlackBoard().get<cv::Mat>(n, SKINDETECTOR_BLACKBOARD_MASK_ENTRY);
      
     if (!getBlackBoard().has(n, FACEDETECTOR_BLACKBOARD_ENTRY)) 
      throw SLMotionException("No face data on the black board!");

     cv::Rect faceLocation = *getBlackBoard().get<cv::Rect>(n, FACEDETECTOR_BLACKBOARD_ENTRY);
      localbb[std::pair<int,std::string>(n,"frame")]=getFrameSource()[n];
      localbb[std::pair<int,std::string>(n,"skinmask")]=getBlackBoard().get<cv::Mat>(n, SKINDETECTOR_BLACKBOARD_MASK_ENTRY);
      localbb[std::pair<int,std::string>(n,"facerect")]=faceLocation;


   //    cv::Mat skinFrame=inFrame.clone();



//       for(int x=0;x<inFrame.cols;x++)
//         for(int y=0;y<inFrame.rows;y++)
//       	 if(mask.at<uchar>(y,x)){
//       	   skinFrame.at<cv::Vec3b>(y,x)=cv::Vec3b(255,50,50);
//       	 }
  

//       cv::imshow("input frame",inFrame);
//        cv::imshow("input frame with detected skin",skinFrame);
//        cv::waitKey(0);   
   }

   // analyse blob progression in the video


   if(last>first){
     recordBlobProgression(first,last-1,localbb);
     //     cout << "blob progression recorded" << endl;
     interpretBlobs(first,last-1,localbb);
     // cout << "blobs interpreted" << endl;
               visualiseInterpretation(first,last-1,localbb);
     //cout << "blobs visualised" << endl;
     // identify frames where left hand starts to occlude the face blob

     map<int,blobinterpretation_type> &interp=*boost::any_cast<map<int,blobinterpretation_type> >(&localbb[std::pair<int,std::string>(0,"blobinterpretation")]);
     BlobProgression &bp=*boost::any_cast<BlobProgression>(&localbb[std::pair<int,std::string>(0,"blobprogression")]);

     // more general: identify all occlusion events

     // first extract the periods of each body part seen 
     // either isolated or as part of a composite blob

     set<int> head_isolated_frames,head_composite_frames,
       lh_isolated_frames,lh_composite_frames,
       rh_isolated_frames,rh_composite_frames;

     set<int> lefthand_head_occlusionstarts;
     set<int> lefthand_head_occlusion_lastframes;

     for(size_t fi=0;fi<bp.blobs.size();fi++){
       //       cout << "frame " << fi+bp.firstframe << endl;

       for(auto it=bp.blobs[fi].begin();it!=bp.blobs[fi].end();it++){
	 // interp[it->label].show();

	 if(interp[it->label].head){
	   if(interp[it->label].isolated)
	     head_isolated_frames.insert(fi+bp.firstframe);
	   else
	     head_composite_frames.insert(fi+bp.firstframe);
	 }

	 if(interp[it->label].left_hand){
	   if(interp[it->label].isolated)
	     lh_isolated_frames.insert(fi+bp.firstframe);
	   else
	     lh_composite_frames.insert(fi+bp.firstframe);
	 }

	 if(interp[it->label].right_hand){
	   if(interp[it->label].isolated)
	     rh_isolated_frames.insert(fi+bp.firstframe);
	   else
	     rh_composite_frames.insert(fi+bp.firstframe);
	 }


       }

     }
   
     // store constraint masks on blackboard for head areas

     // (postpone hand masks so that they can be constrained with unoccluded head areas)

     for(unsigned int f=first;f<last;f++){



       Mat umask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"uniqueblobintmask")]);
       if(head_isolated_frames.count(f)>0 || head_composite_frames.count(f)){

	 localbb[std::pair<int,std::string>(f,"headconstraintmask")]=Mat(umask.rows,umask.cols,CV_8UC1,cv::Scalar::all(0));
	 Mat cmask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"headconstraintmask")]);

	 for(int x=0;x<umask.cols;x++)
	   for(int y=0;y<umask.rows;y++)
	     if(interp[umask.at<int>(y,x)].head)
	       cmask.at<uchar>(y,x)=255;

// 	 cout << "head constraint mask for frame " << f << endl;

// 	 cv::imshow("cmask", cmask);
// 	 cv::waitKey(0);	 

       }

     }
   
     // prepare for occlusion tracking by placing necessary 
     // results to blackboard

     for(unsigned int f=first;f<last;f++){

       placeFloatIntensityOnBlackboard(f,localbb);

     }

     // scan through the set of frames and identify first the intervals
     // when head is occluded

     // track and tag unoccluded points of the head

     // scan first forward in time

     int first_int=first,last_int=last;

     int f=first_int;

     int nr_gridlets_head=100;

     cout << "scanning for head occlusion intervals" << endl;

     do{
       while(f<last_int&&head_isolated_frames.count(f)>0) f++;


       if(f==last_int) break;

       int occlusion_startframe=f;

       //       cout << "found occlusion start at frame " << f << endl;

       while(f<last_int&&head_isolated_frames.count(f)==0) f++;

       int occlusion_lastframe=f-1;

       //       cout << "found occlusion end at frame " << f-1 << endl;

       if(occlusion_startframe==first_int) continue;
       // no unoccluded frames before the occlusion start from where to 
       // initialise tracking

       int clearpast;

       //       cout << "looking for clear reference frames" << endl;

       for(clearpast=1;occlusion_startframe-clearpast>=first_int&&clearpast<10&&
	     head_isolated_frames.count(occlusion_startframe-clearpast);clearpast++);

       clearpast--;

       cout << "clearpast="<<clearpast<<endl;

       if(clearpast>0){

	 // determine the label of the head before the occlusion

// 	 int headlbl_pre=-1;
// 	 int fi=occlusion_startframe-clearpast-bp.firstframe;

// 	 for(auto it=bp.blobs[fi].begin();it!=bp.blobs[fi].end();it++){
// 	   if(interp[it->label].head){
// 	     headlbl_pre=it->label;
// 	     break;
// 	   }
// 	 }

	   cout << "tracking points through head occlusion ["<<occlusion_startframe-clearpast<<","<<
	     occlusion_startframe << "," << occlusion_lastframe << "]"<<endl;

	   detectOccludedArea(occlusion_startframe-clearpast,
			      occlusion_startframe,
			      occlusion_lastframe,
			      nr_gridlets_head,
			      //			      headlbl_pre,
			      "headconstraintmask",
			      "unoccludedheadpoints",
			      localbb); 
	   
       }
       
     } while (f<last_int);

     // then tracking backwards in time
   
     f=last_int-1;

     do{
       while(f>=first_int&&head_isolated_frames.count(f)>0) f--;

       //       cout << "looked for occlusion start


       if(f<first_int) break;

       int occlusion_startframe=f;

       //       cout << "found occlusion start at frame " << f << endl;
       

       while(f>=first_int&&head_isolated_frames.count(f)==0) f--;

       int occlusion_lastframe=f+1;

       //       cout << "found occlusion end at frame " << f+1 << endl;

       if(occlusion_startframe==last_int-1) continue;
       // no unoccluded frames before the occlusion start from where to 
       // initialise tracking

       int clearpast;

       for(clearpast=1;occlusion_startframe+clearpast<last_int&&clearpast<10&&
	     head_isolated_frames.count(occlusion_startframe+clearpast);clearpast++);

       clearpast--;

       //       cout << "clearpast="<<clearpast<<endl;

       if(clearpast>0){

	   cout << "tracking points through head occlusion ["<<occlusion_startframe+clearpast<<","<<
	     occlusion_startframe << "," << occlusion_lastframe << "]"<<endl;

	   detectOccludedArea(occlusion_startframe+clearpast,
			      occlusion_startframe,
			      occlusion_lastframe,
			      nr_gridlets_head,
			      "headconstraintmask",
			      "unoccludedheadpoints",
			      localbb); 
	   
       }
       
       //       cout << "after tracking f=" <<f<< endl;

     } while (f>=first_int);

   

     constructFloatMaskFromPointCloud(first,last-1,"unoccludedheadpoints","unoccludedheadfloatmask",localbb);


     // after tracking unoccluded head areas, track points in hands

     // store constraint masks on blackboard for hand areas

     for(unsigned int f=first;f<last;f++){

       Mat umask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"uniqueblobintmask")]);
       Mat *occl=NULL;

       if(localbb.count(std::pair<int,std::string>(f,"unoccludedheadfloatmask")))
	 occl=boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"unoccludedheadfloatmask")]);

       if(lh_isolated_frames.count(f)>0 || lh_composite_frames.count(f)){
	 localbb[std::pair<int,std::string>(f,"lhconstraintmask")]=Mat(umask.rows,umask.cols,CV_8UC1,cv::Scalar::all(0));
	 Mat cmask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"lhconstraintmask")]);
	 
	 for(int x=0;x<umask.cols;x++)
	   for(int y=0;y<umask.rows;y++)
	     if(interp[umask.at<int>(y,x)].left_hand && (occl==NULL || occl->at<float>(y,x)<0.5))
	       cmask.at<uchar>(y,x)=255;

	 cout << "lhconstraintmask " << f << endl;

// 	 cv::imshow("lhconstraintmask",cmask);
// 	 cv::waitKey(0);   

	 

       }

       if(rh_isolated_frames.count(f)>0 || rh_composite_frames.count(f)){
	 localbb[std::pair<int,std::string>(f,"rhconstraintmask")]=Mat(umask.rows,umask.cols,CV_8UC1,cv::Scalar::all(0));
	 Mat cmask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"rhconstraintmask")]);
	 
	 for(int x=0;x<umask.cols;x++)
	   for(int y=0;y<umask.rows;y++)
	     if(interp[umask.at<int>(y,x)].right_hand && (occl==NULL || occl->at<float>(y,x)<0.5))
	       cmask.at<uchar>(y,x)=255;
       }
     }
	  

     

       int nr_gridlets_hand=40;

       f=first_int;

     do{
       while(f<last_int&&lh_composite_frames.count(f)==0) f++;

       if(f==last_int) break;

       int occlusion_startframe=f;

       cout << "found lh occlusion start at frame " << f << endl;

       while(f<last_int&&lh_composite_frames.count(f)>0) f++;

       int occlusion_lastframe=f-1;

       cout << "found lh occlusion end at frame " << f-1 << endl;

       if(occlusion_startframe==first_int) continue;
       // no unoccluded frames before the occlusion start from where to 
       // initialise tracking

       if(lh_isolated_frames.count(occlusion_startframe-1)==0) continue;
       // occlusion doesn't start by covering of the isolated hand that could be tracked

       cout << "tracking points through lh occlusion ["<<
	     occlusion_startframe << "," << occlusion_lastframe << "]"<<endl;

       trackAreaWithGrid(occlusion_startframe-1,occlusion_lastframe,nr_gridlets_hand,
			 "lhconstraintmask","trackedlefthandpoints_fw",localbb);
       
     } while (f<last_int);


    f=first_int;

     do{
       while(f<last_int&&rh_composite_frames.count(f)==0) f++;

       if(f==last_int) break;

       int occlusion_startframe=f;

       cout << "found rh occlusion start at frame " << f << endl;

       while(f<last_int&&rh_composite_frames.count(f)>0) f++;

       int occlusion_lastframe=f-1;

       cout << "found rh occlusion end at frame " << f-1 << endl;

       if(occlusion_startframe==first_int) continue;
       // no unoccluded frames before the occlusion start from where to 
       // initialise tracking

       if(rh_isolated_frames.count(occlusion_startframe-1)==0) continue;
       // occlusion doesn't start by covering of the isolation hand that could be tracked

       cout << "tracking points through rh occlusion ["<<
	     occlusion_startframe << "," << occlusion_lastframe << "]"<<endl;

       trackAreaWithGrid(occlusion_startframe-1,occlusion_lastframe,nr_gridlets_hand,
			 "rhconstraintmask","trackedrighthandpoints_fw",localbb);
       
     } while (f<last_int);

    f=last_int-1;

     do{
       while(f>=first_int&&lh_composite_frames.count(f)==0) f--;

       if(f<first_int) break;

       int occlusion_startframe=f;

       cout << "found lh occlusion start at frame " << f << endl;

       while(f>=first_int&&lh_composite_frames.count(f)>0) f--;

       int occlusion_lastframe=f+1;

       cout << "found lh occlusion end at frame " << f+1 << endl;

       if(occlusion_startframe==last_int-1) continue;
       // no unoccluded frames before the occlusion start from where to 
       // initialise tracking

       if(lh_isolated_frames.count(occlusion_startframe+1)==0) continue;
       // occlusion doesn't start by covering of the isolated hand that could be tracked

       cout << "tracking points through lh occlusion ["<<
	     occlusion_startframe << "," << occlusion_lastframe << "]"<<endl;

       trackAreaWithGrid(occlusion_startframe+1,occlusion_lastframe,nr_gridlets_hand,
			 "lhconstraintmask","trackedlefthandpoints_bw",localbb);
       
     } while (f>=first_int);

    f=last_int-1;
   
     do{
       while(f>=first_int&&rh_composite_frames.count(f)==0) f--;

       if(f<first_int) break;

       int occlusion_startframe=f;

       cout << "found rh occlusion start at frame " << f << endl;

       while(f>=first_int&&rh_composite_frames.count(f)>0) f--;

       int occlusion_lastframe=f+1;

       cout << "found rh occlusion end at frame " << f+1 << endl;

       if(occlusion_startframe==last_int-1) continue;
       // no unoccluded frames before the occlusion start from where to 
       // initialise tracking

       if(rh_isolated_frames.count(occlusion_startframe+1)==0) continue;
       // occlusion doesn't start by covering of the isolated hand that could be tracked

       cout << "tracking points through rh occlusion ["<<
	     occlusion_startframe << "," << occlusion_lastframe << "]"<<endl;

       trackAreaWithGrid(occlusion_startframe+1,occlusion_lastframe,nr_gridlets_hand,
			 "rhconstraintmask","trackedrighthandpoints_bw",localbb);
       
     } while (f>=first_int);
   
     
     // visualise all tracked points

     for(int f=first;f<last_int;f++){

	   Mat frame=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"frame")]);

	   Mat visframe=frame.clone();

	   if(localbb.count(pair<int,string>(f,"unoccludedheadpoints"))>0){
	     vector<Point> &v=*boost::any_cast<vector<Point> >(&localbb[std::pair<int,std::string>(f,"unoccludedheadpoints")]);

	     for(auto it=v.begin();it!=v.end();it++){
	       visframe.at<Vec3b>(it->y,it->x)=Vec3b(255,255,255);
	     }
	   }

	   if(localbb.count(pair<int,string>(f,"trackedlefthandpoints_fw"))>0){
	     vector<Point> &v=*boost::any_cast<vector<Point> >(&localbb[std::pair<int,std::string>(f,"trackedlefthandpoints_fw")]);

	     for(auto it=v.begin();it!=v.end();it++){
	       visframe.at<Vec3b>(it->y,it->x)=Vec3b(0,255,0);
	     }
	   }

	   if(localbb.count(pair<int,string>(f,"trackedlefthandpoints_bw"))>0){
	     vector<Point> &v=*boost::any_cast<vector<Point> >(&localbb[std::pair<int,std::string>(f,"trackedlefthandpoints_bw")]);

	     for(auto it=v.begin();it!=v.end();it++){
	       visframe.at<Vec3b>(it->y,it->x)=Vec3b(255,0,0);
	     }
	   }

	   if(localbb.count(pair<int,string>(f,"trackedrighthandpoints_fw"))>0){
	     vector<Point> &v=*boost::any_cast<vector<Point> >(&localbb[std::pair<int,std::string>(f,"trackedrighthandpoints_fw")]);

	     for(auto it=v.begin();it!=v.end();it++){
	       visframe.at<Vec3b>(it->y,it->x)=Vec3b(0,0,255);
	     }
	   }

	   if(localbb.count(pair<int,string>(f,"trackedrighthandpoints_bw"))>0){
	     vector<Point> &v=*boost::any_cast<vector<Point> >(&localbb[std::pair<int,std::string>(f,"trackedrighthandpoints_bw")]);

	     for(auto it=v.begin();it!=v.end();it++){
	       visframe.at<Vec3b>(it->y,it->x)=Vec3b(255,0,255);
	     }
	   }

	   cv::imshow("tracked hand and head points", visframe);
	   appendFrameToOutputVideo(visframe,"outputvideo",localbb);

	   cv::waitKey(0);


	 }
   
     //    cout << "tracked points visualised" << endl;
    

//      for(auto it=lefthand_head_occlusionstarts.begin();
// 	 it!=lefthand_head_occlusionstarts.end();it++){
//        cout << "Left hand starts occluding head in frame " << (*it) << endl;
       
//        // find where the occlusion ends

//        int occlusion_lastframe=*it;

//        while(occlusion_lastframe<last&&lefthand_head_occlusion_lastframes.count(occlusion_lastframe)==0) occlusion_lastframe++;

       
//        occlusion_lastframe;

//        if(*it>0)

//        visualiseInterpretation(*it-1,*it,localbb);

//        // determine left hand label in the previous frame

//        int lefthandlbl=-1;
//        int headlbl_pre=-1;
//        set<int> handheadlbl;
//        int nextlefthandlbl=-1;
//        int headlbl_post=-1;

//        int fi=*it-bp.firstframe-1;

//        for(auto it=bp.blobs[fi].begin();
// 	   it!=bp.blobs[fi].end();it++)
// 	 //	 if(interp[it->label].head){	 
// 	 if(interp[it->label].left_hand){
// 	   lefthandlbl=it->label;
// 	 } else	 if(interp[it->label].head){
// 	   headlbl_pre=it->label;
// 	 };


//        for(fi=*it-bp.firstframe;fi<occlusion_lastframe+1-bp.firstframe;fi++){
	 
// 	 for(auto it=bp.blobs[fi].begin();
// 	     it!=bp.blobs[fi].end();it++)
// 	   if(interp[it->label].left_hand){
// 	     //if(interp[it->label].head){
// 	     handheadlbl.insert(it->label);
// 	 }
//        }

//        fi=occlusion_lastframe+1-bp.firstframe;

//        for(auto it=bp.blobs[fi].begin();
// 	   it!=bp.blobs[fi].end();it++)
// 	 	 if(interp[it->label].left_hand){
// 		   //if(interp[it->label].head){
// 	   nextlefthandlbl=it->label;
// 		 } else if(interp[it->label].head){
// 		   headlbl_post=it->label;
// 	 }

//        if(lefthandlbl!=-1){

// 	 Mat uniqueblobintmask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(*it-1,"uniqueblobintmask")]);

	
// 	 vector<grid_type> gridprogression;
// 	 set<int> constraintlbl;

// 	 //	 constraintlbl.insert(lefthandlbl);
// 	 constraintlbl.insert(headlbl_pre);
// 	 // 	 constraintlbl.insert(nextlefthandlbl);
// 		 constraintlbl.insert(headlbl_post);
// // 	 cout << "pre-occlusion left hand label " << lefthandlbl << endl;
// // 	 cout << "during occlusion left hand label " << handheadlbl << endl;

// // 	 cout << "post-occlusion left hand label " << nextlefthandlbl << endl;

// 	 constraintlbl.insert(handheadlbl.begin(),handheadlbl.end()); // this may have to be changed
// 	                                    // if more general situations are tracked  

// 	 // 	 map<int,vector<Point> > unoccludedpoints;

// 	 // prepare for occlusion tracking by placing necessary 
// 	 // results to blackboard

// 	 for(int f=fmax(0,*it-10);f<=occlusion_lastframe+12;f++){

// 	   placeConstraintMaskOnBlackboard(f,localbb,
// 					   "constraintmask",
// 					   "uniqueblobintmask",
// 					   constraintlbl);
// 	   placeFloatIntensityOnBlackboard(f,localbb);

// 	 }

// 	 // forward in time

//  	  detectOccludedArea(fmax(0,*it-10),
//  			    *it,
//  			    occlusion_lastframe+1,
// 			    140,
// 			     // headlbl_pre,
// 			    "constraintmask",
// 			     "unoccludedheadpoints",
// 			     localbb); 

// 	 // backwards in time

//  	 detectOccludedArea(occlusion_lastframe+10,
//  			    occlusion_lastframe,
//  			    *it-1,
// 			    140,
// 			    //			    headlbl_post,
// 			    "constraintmask",
// 			     "unoccludedheadpoints",
// 			    localbb); 

// 	 constructFloatMaskFromPointCloud(fmax(0,*it-10),occlusion_lastframe+12,"unoccludedheadpoints","unoccludedheadfloatmask",localbb);


// 	 Mat mask(uniqueblobintmask.rows,uniqueblobintmask.cols,CV_8UC1,cv::Scalar::all(0));

// 	 for(int i=0;i<uniqueblobintmask.rows;i++)
// 	   for(int j=0;j<uniqueblobintmask.cols;j++){
// 	     mask.at<uchar>(i,j) = (uniqueblobintmask.at<int>(i,j)==lefthandlbl)?255:0;
	     
// 	   }



// 	 constraintlbl.clear();

// 	 constraintlbl.insert(lefthandlbl);
// 	 constraintlbl.insert(nextlefthandlbl);
// 	 constraintlbl.insert(handheadlbl.begin(),handheadlbl.end()); 

// 	 for(int f=fmax(0,*it-2);f<=occlusion_lastframe+2;f++){

// 	   placeConstraintMaskOnBlackboard(f,localbb,
// 					   "constraintmask",
// 					   "uniqueblobintmask",
// 					   constraintlbl);

// // 	   cout << "frame " << f << endl;

// // 	   if(localbb.count(std::pair<int,std::string>(f,"constraintmask"))==0)
// // 	     cout << "cmask not found on blackboard" << endl;

// // 	   if(localbb.count(std::pair<int,std::string>(f,"unoccludedheadfloatmask"))==0)
// // 	     cout << "umask not found on blackboard" << endl;

// 	   // 
// 	   Mat umask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"unoccludedheadfloatmask")]);
// 	   Mat cmask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"constraintmask")]);


// // 	   cv::imshow("cmask", cmask);
// // 	   cv::waitKey(0);
// // 	   cv::imshow("umask", umask);
// // 	   cv::waitKey(0);

// 	   for(int x=0;x<cmask.cols;x++)
// 	     for(int y=0;y<cmask.rows;y++)
// 	       if(umask.at<float>(y,x)==1) cmask.at<uchar>(y,x)=0; 


// 	 }

	 


// // 	 trackAreaWithGrid(occlusion_lastframe+1,*it-1,120,nextlefthandlbl, 
// // 			   "constraintmask","unoccludedheadfloatmask","trackedlefthandpoints",localbb);

// // 	 trackAreaWithGrid(*it-1,occlusion_lastframe+1,120,lefthandlbl, 
// // 			   "constraintmask","unoccludedheadfloatmask","trackedlefthandpoints",localbb);


// 	 for(int f=*it-1;f<=occlusion_lastframe+1;f++){

// 	   Mat frame=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"frame")]);

// 	   Mat visframe=frame.clone();

// 	   if(localbb.count(pair<int,string>(f,"unoccludedheadpoints"))>0){
// 	     vector<Point> &v=*boost::any_cast<vector<Point> >(&localbb[std::pair<int,std::string>(f,"unoccludedheadpoints")]);

// 	     for(auto it=v.begin();it!=v.end();it++){
// 	       visframe.at<Vec3b>(it->y,it->x)=Vec3b(255,0,0);
// 	     }
// 	   }

// 	   if(localbb.count(pair<int,string>(f,"trackedlefthandpoints"))>0){
// 	     vector<Point> &v=*boost::any_cast<vector<Point> >(&localbb[std::pair<int,std::string>(f,"trackedlefthandpoints")]);

// 	     for(auto it=v.begin();it!=v.end();it++){
// 	       visframe.at<Vec3b>(it->y,it->x)=Vec3b(0,255,0);
// 	     }
// 	   }

// 	   //cv::imshow("tracked hand and head points", visframe);
// 	   appendFrameToOutputVideo(visframe,"outputvideo",localbb);

// 	   //cv::waitKey(0);


// 	 }

	 // re-classify pixels in occluded areas to {head,lh,rh}


	 int maxlbl=-1;

	 for(auto it=interp.begin();it!=interp.end();it++)
	   maxlbl=fmax(maxlbl,it->first);

	 int headlbl=maxlbl+1;
	 int lhlbl=maxlbl+2;
	 int rhlbl=maxlbl+3;

	 blobinterpretation_type bi;

	 bi.isolated=true;
	 
	 bi.head=true;
	 bi.uniquelabel=headlbl;
	 interp[headlbl]=bi;

	 bi.head=false;
	 bi.left_hand=true;
	 bi.uniquelabel=lhlbl;
	 interp[lhlbl]=bi;

	 bi.left_hand=false;
	 bi.right_hand=true;
	 bi.uniquelabel=rhlbl;
	 interp[rhlbl]=bi;

	 //	 cout << "labels chosen, interp updated" << endl;

	 for(unsigned int f=first;f<last;f++){

	   //	   cout << "frame " << f << endl;

	   // find out if there is occlusion in the frame

	   if(static_cast<int>(f) < bp.firstframe || f>=bp.firstframe+bp.blobs.size()){
	     throw string("blob progression not recorded for frame");
	   }

	   int fidx=f-bp.firstframe;

	   set<int> compositelabels;

	   for(auto it=bp.blobs[fidx].begin(); it!=bp.blobs[fidx].end();it++){
	     if(interp[it->label].isolated==false)
	       compositelabels.insert(it->label);
	   }

	   if(compositelabels.size()==0) continue;

	   Mat uniqueblobintmask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"uniqueblobintmask")]);
	   Mat frame=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"frame")]);


	   vector<Point> emptyvec;

	   vector<Point> *headptvec=&emptyvec, 
	     *lh_fw_ptvec=&emptyvec, 
	     *lh_bw_ptvec=&emptyvec, 
	     *rh_fw_ptvec=&emptyvec, 
	     *rh_bw_ptvec=&emptyvec; 


	   if(localbb.count(pair<int,string>(f,"unoccludedheadpoints"))>0){
	     headptvec=boost::any_cast<vector<Point> >(&localbb[std::pair<int,std::string>(f,"unoccludedheadpoints")]);
	   }

	   if(localbb.count(pair<int,string>(f,"trackedlefthandpoints_fw"))>0){
	     lh_fw_ptvec=boost::any_cast<vector<Point> >(&localbb[std::pair<int,std::string>(f,"trackedlefthandpoints_fw")]);
	   }

	   if(localbb.count(pair<int,string>(f,"trackedlefthandpoints_bw"))>0){
	     lh_bw_ptvec=boost::any_cast<vector<Point> >(&localbb[std::pair<int,std::string>(f,"trackedlefthandpoints_bw")]);
	   }

	   if(localbb.count(pair<int,string>(f,"trackedrighthandpoints_fw"))>0){
	     rh_fw_ptvec=boost::any_cast<vector<Point> >(&localbb[std::pair<int,std::string>(f,"trackedrighthandpoints_fw")]);
	   }

	   if(localbb.count(pair<int,string>(f,"trackedrighthandpoints_bw"))>0){
	     rh_bw_ptvec=boost::any_cast<vector<Point> >(&localbb[std::pair<int,std::string>(f,"trackedrighthandpoints_bw")]);
	   }

	   if(headptvec->size()+lh_fw_ptvec->size()+lh_bw_ptvec+rh_fw_ptvec->size()+rh_bw_ptvec->size()==0) continue;

	   Mat headmass(frame.rows,frame.cols,cv::DataType<float>::type,cv::Scalar::all(0));
	   Mat lhmass(frame.rows,frame.cols,cv::DataType<float>::type,cv::Scalar::all(0));
	   Mat rhmass(frame.rows,frame.cols,cv::DataType<float>::type,cv::Scalar::all(0));

	   for(auto it=headptvec->begin();it!=headptvec->end();it++){
	     headmass.at<float>(it->y,it->x)=1;
	   }

	   for(auto it=lh_fw_ptvec->begin();it!=lh_fw_ptvec->end();it++){
	     lhmass.at<float>(it->y,it->x)=1;
	   }

	   for(auto it=lh_bw_ptvec->begin();it!=lh_bw_ptvec->end();it++){
	     lhmass.at<float>(it->y,it->x)=1;
	   }

	   for(auto it=rh_fw_ptvec->begin();it!=rh_fw_ptvec->end();it++){
	     rhmass.at<float>(it->y,it->x)=1;
	   }

	   for(auto it=rh_bw_ptvec->begin();it!=rh_bw_ptvec->end();it++){
	     rhmass.at<float>(it->y,it->x)=1;
	   }


	   float dev=10;

	   GaussianBlur(headmass, headmass, cv::Size( 0,0 ),dev);
	   GaussianBlur(lhmass, lhmass, cv::Size( 0,0 ),dev);
	   GaussianBlur(rhmass, rhmass, cv::Size( 0,0 ),dev);

	   Mat visframe=frame.clone();
	   Mat vismass=frame.clone();

	   float maxmass=0;

	   for(int x=0;x<frame.cols;x++)
	     for(int y=0;y<frame.rows;y++){

	       float h=headmass.at<float>(y,x);
	       float l=lhmass.at<float>(y,x);
	       float r=rhmass.at<float>(y,x);

	       maxmass=fmax(fmax(maxmass,h),fmax(l,r));

	       if(compositelabels.count(uniqueblobintmask.at<int>(y,x))){


		 if(h>r && h>l){
		   visframe.at<Vec3b>(y,x)=Vec3b(255,0,0);
		   uniqueblobintmask.at<int>(y,x)=headlbl;
		 } else if(l>=r){
		   visframe.at<Vec3b>(y,x)=Vec3b(0,255,0);
		   uniqueblobintmask.at<int>(y,x)=lhlbl;
		 } else {
		   visframe.at<Vec3b>(y,x)=Vec3b(0,0,255);
		   uniqueblobintmask.at<int>(y,x)=rhlbl;
		 }
	       }
	     }

	   for(int x=0;x<frame.cols;x++)
	     for(int y=0;y<frame.rows;y++){

	       float h=headmass.at<float>(y,x);
	       float l=lhmass.at<float>(y,x);
	       float r=rhmass.at<float>(y,x);

	       vismass.at<Vec3b>(y,x)=Vec3b(255.0*(h/maxmass),255.0*(l/maxmass),(255.0*r/maxmass));

	     }

	   //floatimagesc("headmass", headmass);
	   //floatimagesc("lhmass", lhmass);
	   //floatimagesc("rhmass", rhmass);
	   //cv::imshow("classification", visframe);
	   //	   appendFrameToOutputVideo(vismass,"outputvideo",localbb);
	   //	    cv::waitKey(0);
	 }
   }   

   visualiseInterpretation(first,last-1,localbb);

 	 writeOutputVideo("outputvideo", "outputvideo", 3, localbb);

// 	 for(int pairprevframe=*it-1;pairprevframe<*it+5;pairprevframe++){

	 
// 	 Mat frame=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(pairprevframe,"frame")]);

// 	 Mat nextframe=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(pairprevframe+1,"frame")]);

// 	 Mat uniqueblobintmask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(pairprevframe,"uniqueblobintmask")]);
	 
// 	 Mat fri(frame.rows,frame.cols,CV_8UC1,cv::Scalar::all(0));
// 	 Mat nexti(frame.rows,frame.cols,CV_8UC1,cv::Scalar::all(0));

// 	 // floating point versions of the intensity images

// 	 Mat frif(frame.rows,frame.cols,cv::DataType<float>::type,cv::Scalar::all(0));
// 	 Mat nextif(frame.rows,frame.cols,cv::DataType<float>::type,cv::Scalar::all(0));

// 	 // create B&W versions of the frames

// 	 for(int i=0;i<frame.rows;i++)
// 	   for(int j=0;j<frame.cols;j++){
// 	     fri.at<uchar>(i,j)=(frame.at<Vec3b>(i,j)[0]+
// 				 frame.at<Vec3b>(i,j)[1]+
// 				 frame.at<Vec3b>(i,j)[2])/3;
// 	     frif.at<float>(i,j)=(frame.at<Vec3b>(i,j)[0]+
// 				 frame.at<Vec3b>(i,j)[1]+
// 				 frame.at<Vec3b>(i,j)[2])/3;


// 	     nexti.at<uchar>(i,j)=(nextframe.at<Vec3b>(i,j)[0]+
// 				   nextframe.at<Vec3b>(i,j)[1]+
// 				   nextframe.at<Vec3b>(i,j)[2])/3;

// 	     nextif.at<float>(i,j)=(nextframe.at<Vec3b>(i,j)[0]+
// 				   nextframe.at<Vec3b>(i,j)[1]+
// 				   nextframe.at<Vec3b>(i,j)[2])/3;


// 	   }

// 	 vector<gridpoint_type> grid;
// 	 init_grid(mask,6,grid);

// 	 Mat visframe=frame.clone();
// 	 showgrid(visframe,grid);

// 	 cv::imshow("initial grid", visframe);
// 	 cv::waitKey(0);


// 	 Mat blurred;

// 	 double dev=1;

// 	 GaussianBlur(nextif, blurred, cv::Size( 0,0 ),dev);


      
// 	 vector<Point2f> featuremat;

// 	 int maxCorners=2000;
// 	 double qualityLevel=0.001;
// 	 double minDistance=5;


// 	 //	 cv::goodFeaturesToTrack(fri, featuremat, maxCorners, qualityLevel, 
// 	 //				 minDistance,mask);

//        int sampleinterval=4;

//        // go through the blob mask and perform dense sampling

       

// 	 for(int i=0;i<frame.rows;i+=sampleinterval)
// 	   for(int j=0;j<frame.cols;j+=sampleinterval){
// 	     if(mask.at<uchar>(i,j)>0)
// 	       featuremat.push_back(Point2f(j,i));
// 	   }

// 	 cout << "found " << featuremat.size() << "corners" << endl;


// 	 visframe=frame.clone();

// 	 for(size_t i=0;i<featuremat.size();i++){
// 	   cv::circle(visframe, Point(featuremat[i].x,featuremat[i].y),
// 		      1, Scalar::all(255));
// 	 }

// 	 cv::imshow("detected corner points", visframe);
// 	 cv::waitKey(0);

// 	 // visualise template matching of the "detected" points

// 	 for(size_t pi=0;pi<featuremat.size();pi++){

// 	   Point2f &pt=featuremat[pi];

// 	   int size=38;

// 	   Rect rect;

// 	   rect.x=pt.x;
// 	   rect.y=pt.y;

// 	   rect.width=size;
// 	   rect.height=size;

// 	   Mat templ(frif,rect);

// // 	   Mat templ_0(frif_0,rect);
// // 	   Mat templ_1(frif_1,rect);
// // 	   Mat templ_2(frif_2,rect);


// 	   Mat visframe=frame.clone();
// 	   rectangle(visframe,rect,CV_RGB(0,255,0));

// 	   Mat result,result_b;

// 	   matchTemplate(nextif,templ,result,CV_TM_SQDIFF);

// 	   matchTemplate(blurred,templ,result_b,CV_TM_SQDIFF);

// // 	   matchTemplate(nextif_0,templ,result_0,CV_TM_SQDIFF);
// // 	   matchTemplate(nextif_0,templ,result_1,CV_TM_SQDIFF);
// // 	   matchTemplate(nextif_0,templ,result_2,CV_TM_SQDIFF);
	   
// // 	   result_c =result_0.clone();
// // 	   result_c += result_1;
// // 	   result_c += result_2;


// 	   // scale the result so that fine structure is revealed

// 	   float maxr=result.at<float>(0,0);
// 	   float minr=maxr;

// 	   for(int x=0;x<result.cols;x++)
// 	     for(int y=0;y<result.rows;y++){
// 	       maxr=fmax(maxr,result.at<float>(y,x));
// 	       minr=fmin(minr,result.at<float>(y,x));
// 	     }

// 	   for(int x=0;x<result.cols;x++)
// 	     for(int y=0;y<result.rows;y++){
// 	       float v=result.at<float>(y,x);
// 	       result.at<float>(y,x)=(v>0.05*maxr) ?0 : 1-v/(0.05*maxr);
// 	     }

// 	   maxr=result_b.at<float>(0,0);
// 	   minr=maxr;

// 	   for(int x=0;x<result_b.cols;x++)
// 	     for(int y=0;y<result_b.rows;y++){
// 	       maxr=fmax(maxr,result_b.at<float>(y,x));
// 	       minr=fmin(minr,result_b.at<float>(y,x));
// 	     }

// 	   cout << "min="<<minr<<" max="<<maxr<<endl;

// 	   for(int x=0;x<result_b.cols;x++)
// 	     for(int y=0;y<result_b.rows;y++){
// 	       float v=result_b.at<float>(y,x);
// 	       result_b.at<float>(y,x)=(v>0.05*maxr) ?0 : 1-v/(0.05*maxr);
// 	     }




// 	   // lay the matching result over the next frame

// 	   Mat visnext=nextframe.clone();
// 	   Mat visnext_c=nextframe.clone();

// 	   for(int x=0;x<result.cols;x++)
// 	     for(int y=0;y<result.rows;y++){
// 	       visnext.at<Vec3b>(y,x)[0]=255*result.at<float>(y,x);
// 	       visnext_c.at<Vec3b>(y,x)[0]=255*result_b.at<float>(y,x);
// 	     }


// 	    cv::imshow("matching template", visframe);
// 	    //	    floatimagesc("cropped template", templ);
// 	    floatimagesc("matching result", result);
// 	    floatimagesc("matching result blurred matching", result_b);
// 	    cv::imshow("result laid over the next frame", visnext);
// 	    cv::imshow("blurred result laid over the next frame", visnext_c);
// 	    int k=cv::waitKey(0);

// 	    if(k=='n') break;


// 	 }
	 

// 	 // track the detected points
	 
// 	 vector<Point2f> trackedmat;

// 	 vector<uchar> status;
// 	 vector<float> err;

// 	 //      Mat status;
// 	 //      Mat err;
      
// 	 calcOpticalFlowPyrLK(fri, nexti, featuremat, trackedmat, status, err);

// 	 // visualise the result

// 	 visframe=nextframe.clone();

// 	 int trackcount=0;

// 	 //		 Mat wmat(mask.rows,mask.cols,cv::DataType<float>::type,cv::Scalar::all(0));
// 	 //	 Mat summat(mask.rows,mask.cols,cv::DataType<float>::type,cv::Scalar::all(0));

// 	 vector<Point2f> oldpoints,newpoints;

// 	 for(size_t i=0;i<featuremat.size();i++){

// 	   if(status[i]>0){

// 	     trackcount++;
// 	     cv::circle(visframe, Point(featuremat[i].x,featuremat[i].y),
// 			1, Scalar::all(255));

// 	     cv::line(visframe, Point(featuremat[i].x,featuremat[i].y),
// 		      Point(trackedmat[i].x,trackedmat[i].y),
// 		      cv::Scalar(0, 255, 0));
	     
	     
// 	   }
// 	 }

// 	 cout << "tracked " << trackcount << " points" << endl;
	 
// 	 cv::imshow("tracked corner points", visframe);
// 	 cv::waitKey(0);

// 	 // filter away points that are tracked outside
// 	 // the new hand+head area

// 	 uniqueblobintmask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(pairprevframe+1,"uniqueblobintmask")]);

// 	 visframe=nextframe.clone();

// 	 for(size_t i=0;i<featuremat.size();i++){

// 	   if(status[i]>0){

// 	     if(handheadlbl.count(uniqueblobintmask.at<int>(trackedmat[i].y,
// 							    trackedmat[i].x))==0)
// 	       continue;

// 	     oldpoints.push_back(featuremat[i]);
// 	     newpoints.push_back(trackedmat[i]);

// 	     cv::circle(visframe, Point(featuremat[i].x,featuremat[i].y),
// 			1, Scalar::all(255));

// 	     cv::line(visframe, Point(featuremat[i].x,featuremat[i].y),
// 		      Point(trackedmat[i].x,trackedmat[i].y),
// 		      cv::Scalar(0, 255, 0));
	     
	     
// 	   }
// 	 }

// 	 cv::imshow("tracked corner points within hand+head", visframe);
// 	 cv::waitKey(0);

// 	 Mat motionfield=frame.clone();

// 	 estimateSmoothMotionField(oldpoints,newpoints,motionfield);

// 	 // visualise the motion field

// 	visframe=nextframe.clone();
// 	for(int i=0;i<visframe.rows;i++)
// 	  for(int j=0;j<visframe.cols;j++){
// 	    visframe.at<Vec3b>(i,j)[0]=128+motionfield.at<Point2f>(i,j).x;
// 	    visframe.at<Vec3b>(i,j)[1]=128+motionfield.at<Point2f>(i,j).y;
// 	    visframe.at<Vec3b>(i,j)[2]=0;
// 	  }

//         cv::imshow("estimated motion field", visframe);
// 	cv::waitKey(0);  

// 	// filter tracked points by motion typicality constraint

// 	vector<Point2f> o_tmp=oldpoints,n_tmp=newpoints;

// 	oldpoints.clear();
// 	newpoints.clear();

// 	visframe=nextframe.clone();
// 	for(size_t i=0;i<o_tmp.size();i++){

// 	  int mx=o_tmp[i].x-n_tmp[i].x;
// 	  int my=o_tmp[i].y-n_tmp[i].y;

// 	  Point2f ave=motionfield.at<Point2f>(o_tmp[i].y,o_tmp[i].x);
	  
// 	  float dx=mx-ave.x;
// 	  float dy=my-ave.y;

// 	  float diffmargin=10;

// 	  if(dx*dx+dy*dy<=diffmargin*diffmargin){
// 	    oldpoints.push_back(o_tmp[i]);
// 	    newpoints.push_back(n_tmp[i]);

// 	    cv::circle(visframe, Point(o_tmp[i].x,o_tmp[i].y),
// 		       1, Scalar::all(255));

// 	     cv::line(visframe, Point(o_tmp[i].x,o_tmp[i].y),
// 		      Point(n_tmp[i].x,n_tmp[i].y),
// 		      cv::Scalar(0, 255, 0));

// 	  }

// 	}

//         cv::imshow("tracks filtered by motion constraint", visframe);
// 	cv::waitKey(0);  


// 	Mat newmask;

// 	updateMaskByTrackedPoints(mask,newmask,oldpoints,newpoints);

// 	// keep only such points in the updated mask that
// 	// overlap with the hand+head blob


// 	for(int i=0;i<newmask.rows;i++)
// 	  for(int j=0;j<newmask.cols;j++){
// 	    if(handheadlbl.count(uniqueblobintmask.at<int>(i,j))==0)
// 	      newmask.at<uchar>(i,j)=0;
// 	  }

// 	visframe=nextframe.clone();

// 	 for(int i=0;i<visframe.rows;i++)
// 	   for(int j=0;j<visframe.cols;j++){
// 	     visframe.at<Vec3b>(i,j)[0]=newmask.at<uchar>(i,j);
// 	   }

//         cv::imshow("old mask", mask);
//         cv::imshow("updated mask", newmask);
//         cv::imshow("updated mask overlaid with next frame", visframe);
// 	cv::waitKey(0);  

// 	mask=newmask;

// 	 }


//        }
// 	 // 


//        Mat frame=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(*it,"frame")]);

//         cv::imshow("frame", frame);
// 	cv::waitKey(0);  

	

//      }

     


//      extractIsolatedHands(first,last-1,localbb);
//    }


   return true;


  }

  Component* VviComponent::createComponentImpl(const boost::program_options::variables_map&, BlackBoard* blackBoard, FrameSource* frameSource) const {
    return new VviComponent(blackBoard, frameSource);
  }


}



