#include "XmlDocument.hpp"
#include "MemoryStream.hpp"
#include "util.hpp"
#include "Validator.hpp"
#include "exceptions.hpp"
#include <sstream>

using std::string;

namespace slmotion {
  namespace xml {
    void XmlDocument::initialise(const string& filename) {
      xmlKeepBlanksDefault(0); // Required to allow indendation while writing
      internalDoc = InternalDocPtr(xmlReadFile(filename.c_str(), NULL, 0),
                                   &xmlFreeDoc);
      if (!internalDoc.get())
        throw ConvertException(string("Failed to read the supplied XML file ('" + filename + "')").c_str());
      setRootElement(XmlNode(xmlDocGetRootElement(internalDoc.get())));
    }



    void XmlDocument::save(const string& filename) {
      xmlSaveFormatFile(filename.c_str(), internalDoc.get(), 1);
    }



    std::ostream& XmlDocument::print(std::ostream& os) const {
      // 1. Store the XML to a temporary array
      MemoryStream memstream;

      xmlOutputBufferPtr buffer = xmlOutputBufferCreateFile(memstream, NULL);
      if (buffer == NULL)
        throw slmotion::ConvertException("Failed to allocate output file buffer for writing formatted XML");
      if(xmlSaveFormatFileTo(buffer, internalDoc.get(), NULL, 
                             true) < 0)
        throw slmotion::ConvertException("Failed to write XML to buffer!");

      std::vector<char> memtemp(memstream.getData());

      // 2. Reread the data, one line at a time, from the 
      // temporary array, and write it to the target output stream
      // with an "# " appended at the beginning
      // std::istringstream istr;
      // istr.rdbuf()->pubsetbuf(&memtemp[0], memtemp.size());
      // string s;
      // while (getline(istr, s))
      //   os << "# " << s << std::endl;
 
      // while (getline(istr, s))
      //  os << s << std::endl;

      // Why do things in such a difficult manner?

      return os.write(&memtemp[0], memtemp.size());
    }



    std::ostream& operator<<(std::ostream& os, const slmotion::xml::XmlDocument& doc) {
      return doc.print(os);
    }



    void XmlDocument::setRootElement(XmlNode&& node) {
      xmlUnlinkNode(*rootElement.internalNode);
      xmlFreeNode(*rootElement.internalNode);
      *rootElement.internalNode = NULL;

      rootElement = node;
      xmlDocSetRootElement(internalDoc.get(), *rootElement.internalNode);
      *rootElement.shouldDelete = false;
    }



    // XmlDocument::setSchema(const std::string& schemafile)  {
    //   validator = std::shared_ptr<Validator>(new Validator(schemafile));
    // }



    XmlDocument::XmlDocument(const std::string& xmlDoc) : 
      internalDoc(NULL, xmlFreeDoc) {
      initialise(xmlDoc);
    }



    // bool XmlDocument::validate() { 
    //   return validator->validate(*this);
    // }
  }
}





