#ifndef SLMOTION_XML_VALIDABLE_DOCUMENT
#define SLMOTION_XML_VALIDABLE_DOCUMENT

#include "Validator.hpp"
#include "exceptions.hpp"

namespace slmotion {
  namespace xml {
    /**
     * Effectively an XmlDocument that also knows how to validate itself
     */
    class XmlValidableDocument : public XmlDocument {
    public:
      explicit XmlValidableDocument(const Validator& validator) :
        validator(validator) { }

      explicit XmlValidableDocument(const Validator& validator,
                                    const std::string& xmlFilename) :
        XmlDocument(xmlFilename),
        validator(validator) {
        if (!validate())
          throw ConvertException(std::string("Tried to open an XML file for writing that could not be validated ('" + xmlFilename +"'). The schema that was used was " + validator.getSchema()).c_str());
      }

      /**
       * Self-validate
       */
      bool validate() const {
        return validator.validate(*this);
      }

    private:
      Validator validator;
    };
  }
}

#endif
