#!/usr/bin/python

import sys
import subprocess

if len(sys.argv) != 2:
    print "usage: createid.py <filename>"
    print "Creates a CVS'ish $Id: $ tag for the given file, given its Git history, and "
    print "prints the result to stdout"
    sys.exit(1)

filename = sys.argv[1]

if filename == "*":
    p1 = subprocess.Popen(["git", "log", "--oneline"], 
                          stdout=subprocess.PIPE)
else:
    p1 = subprocess.Popen(["git", "log", "--oneline", filename], 
                          stdout=subprocess.PIPE)
p2 = subprocess.Popen(["wc", "-l"], stdin=p1.stdout, stdout=subprocess.PIPE)
numberOfCommits = p2.communicate()[0][:-1]

if filename == "*":
    p1 = subprocess.Popen(["git", "log", "--pretty=format:%h %ai %cn <%ce>"], 
                          stdout=subprocess.PIPE)
else:
    p1 = subprocess.Popen(["git", "log", "--pretty=format:%h %ai %cn <%ce>", filename], 
                          stdout=subprocess.PIPE)
p2 = subprocess.Popen(["head", "-n", "1"], stdin=p1.stdout, stdout=subprocess.PIPE)
logmsg = p2.communicate()[0][:-1]

p1 = subprocess.Popen(["git", "name-rev", "--name-only", "HEAD"], 
                      stdout=subprocess.PIPE)
branchname = p1.communicate()[0][:-1]

if filename == "*":
    filename = "slmotion"
print "namespace slmotion {\n  extern const char* const SLMOTION_VCID = \"" + filename + " " + branchname + " v" + numberOfCommits + " " + logmsg + "\";\n}"

