#ifndef SLMOTION_EXCEPTIONS
#define SLMOTION_EXCEPTIONS

#include "SLMotionException.hpp"
#include <string>

namespace slmotion {
  /**
   * A simple exception class for signaling invalid configuration
   * parameters.
   */
  class ConfigurationFileException : public SLMotionException {
  public:
    /**
     * A simple constructor
     *
     * @param msg An explanatory message
     */
    explicit ConfigurationFileException(const char* msg) :
      SLMotionException(msg)
    {}



    explicit ConfigurationFileException(const std::string& msg) :
      SLMotionException(msg.c_str())
    {}



    virtual ~ConfigurationFileException() throw() {}
  };



  /**
   * A simple exception class for signaling invalid command line parameters.
   */
  class CommandLineException : public SLMotionException {
  public:
    /**
     * A simple constructor
     *
     * @param msg An explanatory message
     */
    explicit CommandLineException(const char* msg) :
      SLMotionException(msg)
    {}



    explicit CommandLineException(const std::string& msg) :
      SLMotionException(msg.c_str())
    {}



    virtual ~CommandLineException() throw() {}
  };



  /**
   * A very simple class to signal exceptional events during data conversion
   */
  class ConvertException: public SLMotionException {
  public:
    /**
     * A very simple constructor
     *
     * @param msg An explanatory message
     */
    explicit ConvertException(const char* msg) throw() :
      SLMotionException(msg)
    {}

    explicit ConvertException(const std::string& msg) throw() :
      SLMotionException(msg.c_str())
    {}

    virtual ~ConvertException() throw() {}
  };



  /**
   * A very simple class to signal exceptional events during analysis
   */
  class AnalysisException : public SLMotionException {
  public:
    /**
     * A very simple constructor
     *
     * @param msg An explanatory message
     */
    explicit AnalysisException(const std::string& msg) :
      SLMotionException(msg.c_str())
    {}

    virtual ~AnalysisException() throw() {}
  };

  class IOException : public SLMotionException {
  public:
    explicit IOException(const std::string& msg) throw() :
      SLMotionException(msg.c_str()) {}
    
    virtual ~IOException() throw() {}
  };


  class XMLException : public SLMotionException {
  public:
    explicit XMLException(const std::string& msg) throw() :
      SLMotionException(msg.c_str()) {}
    
    virtual ~XMLException() throw() {}
  };
}
#endif
