#include "HandVisualiser.cpp"
#include "HandConfiguration.hpp"
#include "AdvancedString.hpp"
#include <opencv2/opencv.hpp>

using slmotion::AdvancedString;

int main(int argc, char **argv) {
  if (argc < 2) {
    std::cout << "usage: " << argv[0] << " " << "<filename>" << std::endl;
    std::cout << "Loads a hand configuration from <filename>. If <filename> "
              << "does not exist, it will be created. The updated hand "
              << "configuration will be stored in this file."
              << std::endl;
    return 0;
  }

  std::string filename = argv[1];
  std::ifstream ifs(filename);
  cv::Mat configuration(25, 1, CV_64FC1);
  configuration = 0.0;
  if (ifs.good()) {
    std::string s;
    std::vector<slmotion::AdvancedString> lines;
    while (std::getline(ifs, s))
      lines.push_back(s);
    if (lines.size() != 25) {
      std::cerr << argv[0] << ": ERROR: \"" << filename << "\" contains an "
                << "invalid hand configuration. Parameter count mismatch: "
                << "Expected 25 parameters but got " << lines.size() << "!"
                << std::endl;
      return -1;
    }
    for (int i = 0; i < 25; ++i)
      configuration.at<double>(i,0) = static_cast<float>(lines[i]);
  }
  ifs.close();


  try {
    slmotion::HandVisualiser hv;

    slmotion::HandConfiguration hc = slmotion::HandConfiguration(configuration);

    // number of configuration element, or KEY_R, KEY_T, KEY_Y, KEY_U
    // for range, theta, phi, tilt, respectively
    int selected = 0;
    std::string textLine;
 
    const std::set<int> NUMPAD_0 = {1114032, 65438};
    const std::set<int> NUMPAD_1 = {1114033, 65436};
    const std::set<int> NUMPAD_2 = {1114034, 65433};
    const std::set<int> NUMPAD_3 = {1114035, 65435};
    const std::set<int> NUMPAD_4 = {1114036, 65430};
    const std::set<int> NUMPAD_5 = {1114037, 65437};
    const std::set<int> NUMPAD_6 = {1114038, 65432};
    const std::set<int> NUMPAD_7 = {1114039, 65429};
    const std::set<int> NUMPAD_8 = {1114040, 65431};
    const std::set<int> NUMPAD_9 = {1114041, 65434};
    const std::set<int> NUMPAD_PLUS = {1114027, 65451};
    const std::set<int> NUMPAD_MINUS = {1114029, 65453};
    const std::set<int> NUMPAD_DIV = {1114031, 65455};
    const std::set<int> NUMPAD_MULT = {1114026, 65450};
    const double STEP_RAD = 3.14159 / 36;
    const double STEP_DEG = 180. / 36;

    const std::set<int> KEY_Q = {1048689, 113};
    const std::set<int> KEY_R = {1048690, 114};
    const std::set<int> KEY_S = {1048691, 115};
    const std::set<int> KEY_T = {1048692, 116};
    const std::set<int> KEY_Y = {1048697, 121};
    const std::set<int> KEY_U = {1048693, 117};
    const std::set<int> KEY_1 = {1048625, 49};
    const std::set<int> KEY_2 = {1048626, 50};
    const std::set<int> KEY_3 = {1048627, 51};
    const std::set<int> KEY_4 = {1048628, 52};
    const std::set<int> KEY_5 = {1048629, 53};
    const std::set<int> KEY_6 = {1048630, 54};
    const std::set<int> KEY_7 = {1048631, 55};
    const std::set<int> KEY_8 = {1048632, 56};
    const std::set<int> KEY_9 = {1048633, 57};
    const std::set<int> KEY_0 = {1048624, 48};

    int key = 0;
    // int i = 0;
    double r, phi, theta, tilt;
    r = phi = theta = 0;
    // tilt = 3.1415/2.;
    tilt = 0;

    r = 10;
    tilt = 3.1415/2.;
    while (!KEY_Q.count(key)) {
      if (NUMPAD_PLUS.count(key)) {
        if (KEY_R.count(selected))
          r += 1;
        else if (KEY_T.count(selected))
          theta += STEP_RAD;
        else if (KEY_Y.count(selected))
          phi += STEP_RAD;
        else if (KEY_U.count(selected))
          tilt += STEP_RAD;
        else if (selected >= 0 && selected < 25)
          configuration.at<double>(selected,0) += STEP_DEG;
      }
      else if (NUMPAD_MINUS.count(key)) {
        if (KEY_R.count(selected))
          r -= 1;
        else if (KEY_T.count(selected))
          theta -= STEP_RAD;
        else if (KEY_Y.count(selected))
          phi -= STEP_RAD;
        else if (KEY_U.count(selected))
          tilt -= STEP_RAD;
        else if (selected >= 0 && selected < 25)
          configuration.at<double>(selected,0) -= STEP_DEG;
      }
      else if (NUMPAD_0.count(key) ||
	       NUMPAD_1.count(key) ||
	       NUMPAD_2.count(key) ||
	       NUMPAD_3.count(key) ||
	       NUMPAD_4.count(key) ||
	       NUMPAD_5.count(key) ||
	       NUMPAD_6.count(key) ||
	       NUMPAD_7.count(key) ||
	       NUMPAD_8.count(key) ||
	       NUMPAD_9.count(key) ||
	       KEY_0.count(key) ||
	       KEY_1.count(key) ||
	       KEY_2.count(key) ||
	       KEY_3.count(key) ||
	       KEY_4.count(key) ||
	       KEY_5.count(key) ||
	       KEY_6.count(key) ||
	       KEY_7.count(key) ||
	       KEY_8.count(key) ||
	       KEY_9.count(key)) {
        if (NUMPAD_0.count(selected) || KEY_0.count(selected)) {
	  if (NUMPAD_0.count(key) || KEY_0.count(key))
	    selected = 0;
	  else if (NUMPAD_1.count(key) || KEY_1.count(key))
	    selected = 1;
	  else if (NUMPAD_2.count(key) || KEY_2.count(key))
	    selected = 2;
	  else if (NUMPAD_3.count(key) || KEY_3.count(key))
	    selected = 3;
	  else if (NUMPAD_4.count(key) || KEY_4.count(key))
	    selected = 4;
	  else if (NUMPAD_5.count(key) || KEY_5.count(key))
	    selected = 5;
	  else if (NUMPAD_6.count(key) || KEY_6.count(key))
	    selected = 6;
	  else if (NUMPAD_7.count(key) || KEY_7.count(key))
	    selected = 7;
	  else if (NUMPAD_8.count(key) || KEY_8.count(key))
	    selected = 8;
	  else if (NUMPAD_9.count(key) || KEY_9.count(key))
	    selected = 9;
        }
        else if (NUMPAD_1.count(selected) || KEY_1.count(selected)) {
	  if (NUMPAD_0.count(key) || KEY_0.count(key))
	    selected = 10;
	  else if (NUMPAD_1.count(key) || KEY_1.count(key))
	    selected = 11;
	  else if (NUMPAD_2.count(key) || KEY_2.count(key))
	    selected = 12;
	  else if (NUMPAD_3.count(key) || KEY_3.count(key))
	    selected = 13;
	  else if (NUMPAD_4.count(key) || KEY_4.count(key))
	    selected = 14;
	  else if (NUMPAD_5.count(key) || KEY_5.count(key))
	    selected = 15;
	  else if (NUMPAD_6.count(key) || KEY_6.count(key))
	    selected = 16;
	  else if (NUMPAD_7.count(key) || KEY_7.count(key))
	    selected = 17;
	  else if (NUMPAD_8.count(key) || KEY_8.count(key))
	    selected = 18;
	  else if (NUMPAD_9.count(key) || KEY_9.count(key))
	    selected = 19;
        }
        else if (NUMPAD_2.count(selected) || KEY_2.count(selected)) {

	  if (NUMPAD_0.count(key) || KEY_0.count(key))
	    selected = 20;
	  else if (NUMPAD_1.count(key) || KEY_1.count(key))
	    selected = 21;
	  else if (NUMPAD_2.count(key) || KEY_2.count(key))
	    selected = 22;
	  else if (NUMPAD_3.count(key) || KEY_3.count(key))
	    selected = 23;
	  else if (NUMPAD_4.count(key) || KEY_4.count(key))
	    selected = 24;
	  else if (NUMPAD_5.count(key) || KEY_5.count(key))
	    selected = 25;
	  else if (NUMPAD_6.count(key) || KEY_6.count(key))
	    selected = 26;
	  else if (NUMPAD_7.count(key) || KEY_7.count(key))
	    selected = 27;
	  else if (NUMPAD_8.count(key) || KEY_8.count(key))
	    selected = 28;
	  else if (NUMPAD_9.count(key) || KEY_9.count(key))
	    selected = 29;
        }
        else
          selected = key;
      }
      else if (KEY_R.count(key) || KEY_T.count(key) || KEY_Y.count(key) || KEY_U.count(key))
        selected = key;
      else if (KEY_S.count(key)) {
        selected = *KEY_S.begin();
        std::ofstream ofs(filename);
        for (int i = 0; i < configuration.rows; ++i)
          ofs << configuration.at<double>(i,0) << std::endl;
      }

      if (KEY_0.count(selected) || NUMPAD_0.count(selected))
        textLine = "select: 0_";
      else if (KEY_1.count(selected) || NUMPAD_1.count(selected))
        textLine = "select: 1_";
      else if (KEY_2.count(selected) || NUMPAD_2.count(selected))
        textLine = "select: 2_";
      else if (KEY_3.count(selected) || NUMPAD_3.count(selected))
        textLine = "select: 3_";
      else if (KEY_4.count(selected) || NUMPAD_4.count(selected))
        textLine = "select: 4_";
      else if (KEY_5.count(selected) || NUMPAD_5.count(selected))
        textLine = "select: 5_";
      else if (KEY_6.count(selected) || NUMPAD_6.count(selected))
        textLine = "select: 6_";
      else if (KEY_7.count(selected) || NUMPAD_7.count(selected))
        textLine = "select: 7_";
      else if (KEY_8.count(selected) || NUMPAD_8.count(selected))
        textLine = "select: 8_";
      else if (KEY_9.count(selected) || NUMPAD_9.count(selected))
        textLine = "select: 9_";
      else if (selected >= 0 && selected < 25) {
        textLine = slmotion::HandConfiguration::jointName(selected) + ": " + 
          AdvancedString(configuration.at<double>(selected,0));
      }
      else if (KEY_R.count(selected))
        textLine = "r: " + AdvancedString(r);
      else if (KEY_T.count(selected))
        textLine = "theta: " + AdvancedString(theta/3.1415*180.);
      else if (KEY_Y.count(selected))
        textLine = "phi: " + AdvancedString(phi/3.1415*180.);
      else if (KEY_U.count(selected))
        textLine = "tilt: " + AdvancedString(tilt/3.1415*180.);
      else if (KEY_S.count(selected))
        textLine = "saved";
      else
        textLine = "";

      hc = configuration;
      cv::Mat temp = hv.render(hc, r, theta, phi, tilt);
      cv::putText(temp, textLine, cv::Point(5, 20), cv::FONT_HERSHEY_PLAIN, 1.0, cv::Scalar::all(255));

      cv::imshow("Hand", temp);
      key = cv::waitKey(0);
    }
    // phi = 3.1415/2.;
    // theta = 3.1415/2.;
    #if 0
    cv::Mat m(25, 1, CV_64FC1, cv::Scalar::all(0));
    cv::Mat n(25, 1, CV_16SC1, cv::Scalar::all(1));
    cv::VideoWriter vw("/users/jmkarppa/twisted_hand.avi", CV_FOURCC('F','M','P','4'), 25, 
                       hv.render(hc, r, theta, phi, tilt).size());
    for (int i = 0; i < 1000; ++i) {
      int k = rand() % m.rows;
      short& sign = n.at<short>(k);
      double& val = m.at<double>(k);
      if (val > 45)
        sign = -1;
      else if (val < -45)
        sign = +1;
      val += sign*45./12.;
      hc = m;
      vw << hv.render(hc, r, theta, phi, tilt);
      // std::cout << i << std::endl;
      // cv::imshow("Hand", hv.render(hc, r, theta, phi, tilt));
      // cv::waitKey(40);
      phi = fmod(phi + STEP, 2*3.1415);
    }
#endif
  } catch (const std::exception &e) {
    std::cerr << "Exception: " << e.what() << std::endl;
  }
 
  return 0;
}




