/*
 *
 * This file is obsolete. Please do not use it. The functionality presented
 * here has been moved to slmotion.cpp and slmotionmain.cpp.
 *
 */


#include <iostream>
#include <fstream>
#include <boost/program_options.hpp>

#include "cv.h"
#include "highgui.h"

#include "slmotion.h"
#include "facedetector.h"
#include "skinfilter.h"
#include "featuretracker.h"
#include "slio.h"
#include "analyser.h"
using slmotion::ConfigurationFileException;
using slmotion::CommandLineException;
using slmotion::Analyser;
using slmotion::SLIO;
using std::string;
using std::auto_ptr;
using std::vector;
using std::cerr;
using std::endl;
using slmotion::PDM;
using std::max;
using std::min;
using cv::Rect;



const string slmotion_C_vcid =
  "@(#)$Id: slmotion.C,v 1.119 2010-09-22 14:02:07 jmkarppa Exp $";

namespace po = boost::program_options;

namespace slmotion {
  int debug = 0;
}

// ---------------------------------------------------------------------

int main( int argc, char** argv ) {
  const string DEFAULT_CONFIGURATION_FILE = "default.conf";
  const string WINDOWNAME  = "output";

  string conffile = DEFAULT_CONFIGURATION_FILE;

  auto_ptr<slmotion::FeatureTracker> featureTracker(new slmotion::FeatureTracker());

  auto_ptr< vector<double> > ddata;

  double facescalex = 1.0;
  double facescaley = 1.0;
  string inputName;

  slmotion::SkinFilter::SkinOpts skinOpts;
  slmotion::Analyser::AnalyserOpts analyserOpts;
  slmotion::FaceDetector::FaceDetectorOpts faceDetectorOpts;

  bool videoOut = false;
  bool aspectCorrection = false;
  double aspect = 1.33;

  SLIO::VidLib videoLibrary = SLIO::OPENCV;

  double videoFps = 25;
  string videoFourcc = "MJPG";

  // Parse program line arguments using libbboost program options
  try {
    po::options_description visible("Available options");
    visible.add_options()
      ("help", "prints this help message")
      ("verbose,v", "enables more verbose output (same as --debug 1)")
      ("debug", po::value<int>(&slmotion::debug), "sets the debug message verbosity level (disabled at 0)")
      ("config,c", po::value<string>(&conffile), "sets the configuration file")
      ("face-cascade", po::value<string>(),
       "sets the cascade file for the Haar classifier used by the face detector")
      ("out,o", po::value<string>(&analyserOpts.outFilename), "sets the output filename for visual data")
      ("video-out", "enables video output")
      ("md-out", po::value<string>(&analyserOpts.mdOutFilename), "sets the output filename for motion descriptor data, stored in CSV format")
      ("elan-out", po::value<string>(&analyserOpts.elanFilename), "sets the output filename for ELAN XML data. If the file exists, new tiers are added to it. Otherwise, a new file is created.")
      ("vector-out-file", po::value<string>(), "stores vectors used in the Gaussian distribution in a file in CSV format")
      ("cache-out-file", po::value<string>(), "stores contents of the Gaussian probability distribution cache in a file in an architecture-dependent format")
      ("cache-file", po::value<string>(), "loads a previously saved Gaussian  distribution cache from a file")
      ("frames", po::value<size_t>(&analyserOpts.framesMax),
       "only process arg frames")
      ("skip", po::value<size_t>(&analyserOpts.skipFrames),
       "skip arg first frames")
      ("aspect", po::value<string>(),
       "scales the video to the desired aspect ratio")
      ("ann-format", po::value<string>(&analyserOpts.annFormat),
       "sets a formatting string for the annotation bar")
      ("ann-file", po::value<string>(&analyserOpts.annFilename),
       "sets the file from which annotations are read")
      ("ann-template-file", po::value<string>(),
       "sets a file from which annotation templates are read")
      ("no-face-detection", "disables face detection")
      ("mode", po::value<string>(), "sets the operation mode: oldlk (default) or new")
      ("no-tracking", "disables feature tracking")
      ("no-md-analysis", "disables motion descriptor analysis" )
      ("no-blob-detection", "disables blob detection")
      ("no-body-part-classification", "disables body part classification")
      ("no-body-part-history-collection", "disables body part shape history collection")
      ("no-face-cache", "disables face detection cache")
      ("no-body-part-cache", "disables body part cache")
      ("show-blob-cent", "draws white crosses at blob centroids")
      ("show-blobs", "draws the blobs on the image in fancy colours")
      ("show-detected-body-parts",
       "colours detected body parts as follows: red for left hand, blue for right hand, green for the head, and combinations of body parts will be coloured by combining the colours, e.g. yellow for a left hand / head combo")
      ("show-corners", "draws white circles around found features")
      ("show-tracked-points", "draws white circles around tracked features")
      ("show-tracked-points2", "draws coloured circles around tracked features in the post-processing phase (only available if seglk mode)")
      ("show-face", "draws a box where face is detected")
      ("show-motion-vectors", "shows motion vectors. Each frame will be drawn "\
       "one frame late because future information will be needed.")
      ("show-acc-vectors", "shows acceleration vectors like motion vectors")
      ("show-estimated-anchors", "shows estimated anchor points used for body part estimation using ASMs")
      ("show-asms", "draws lines around detected ASMs")
      ("show-gradient-map", "draws a gradient map of the image")
      ("show-gradient-map2d", "draws a gradient map of the image where hue represents the direction and value the magnitude")
      ("show-canny-map", "draws a map of edges as detected by the Canny edge detector")
      ("pause,p", "pauses between each image until a key is pressed");

    po::options_description hidden("Hidden options");
    hidden.add_options()
      ("inputName", po::value<string>(&inputName), "input video filename");
    po::options_description cmdOpts;
    cmdOpts.add(visible).add(hidden);

    po::positional_options_description p;
    p.add("inputName", 1);

    po::variables_map vm;
    po::store(po::command_line_parser(argc, argv).options(cmdOpts).positional(p).
	      run(), vm);
    po::notify(vm);

    // declare section-aware configuration file options

    po::options_description conffileOpts;
    conffileOpts.add_options()
      ("global.annformat", po::value<string>())
      ("global.aspect", po::value<string>())
      ("global.facedetection", po::value<bool>())
      ("global.tracking", po::value<bool>())
      ("global.mdanalysis", po::value<bool>())
      ("global.mode", po::value<string>())
      ("global.videolibrary", po::value<string>())
      ("global.videooutput", po::value<bool>())
      ("global.videofourcc", po::value<string>())
      ("global.videofps", po::value<double>())
      ("global.annotationtemplates", po::value<string>())
      ("skin.thresholds", po::value<string>())
      ("skin.method", po::value<string>())
      ("skin.colourspace", po::value<string>())
      ("skin.output", po::value<string>())
      ("skin.fillholes", po::value<bool>())
      ("skin.extcontours", po::value<int>())
      ("skin.dilate", po::value<int>())
      ("skin.erode", po::value<int>())
      ("skin.open", po::value<int>())
      ("skin.stdev", po::value<string>())
      ("skin.detectblobs", po::value<bool>())
      ("skin.blobremoval", po::value<bool>())
      ("skin.blobs", po::value<int>())
      ("skin.minblobsize", po::value<int>())
      ("skin.minblobdistance", po::value<int>())
      ("skin.crop", po::value<string>())
      ("gauss3d.vectoroutfile", po::value<string>())
      ("gauss3d.cacheoutfile", po::value<string>())
      ("gauss3d.cachefile", po::value<string>())
      ("gauss3d.probthreshold", po::value<double>())
      ("gauss3d.continuous", po::value<bool>())
      ("gauss3d.kcolours", po::value<int>())
      ("gauss3d.rcolours", po::value<int>())
      ("gauss3d.cache", po::value<string>())
      ("gauss3d.init", po::value<string>())
      ("gauss3d.initfile", po::value< vector<string> >())
      ("gauss3d.patch", po::value< vector<string> >())
      ("gauss3d.removeoutliers", po::value<int>())
      ("gauss3d.clusterattempts", po::value<int>())
      ("facedetection.cascade", po::value<string>())
      ("facedetection.scale", po::value<string>())
      ("facedetection.maxmove", po::value<int>())
      ("facedetection.maxareachange", po::value<double>())
      ("facedetection.cache", po::value<bool>())
      ("tracking.noblackmask", po::value<bool>())
      ("tracking.preserveoldpoints", po::value<bool>())
      ("tracking.maxneweigenerror", po::value<double>())
      ("tracking.maxfoundeigenerror", po::value<double>())
      ("tracking.maxframeerror", po::value<double>())
      ("tracking.gfquality", po::value<double>())
      ("tracking.gfmindistance", po::value<double>())
      ("tracking.maxpoints", po::value<int>())
      ("tracking.maxmove", po::value<int>())
      ("analysis.bodypartclassification", po::value<bool>())
      ("analysis.classifyheadsizefactor",
       po::value<double>(&analyserOpts.classifyHeadSizeFactor))
      ("analysis.classifyheadmaxdistance",
       po::value<int>(&analyserOpts.classifyHeadMaxDistance))
      ("analysis.goodframeminimumhorizontaldistance",
       po::value<int>(&analyserOpts.goodFrameMinHandHDist))
      ("analysis.goodframeminimumverticaldistance",
       po::value<int>(&analyserOpts.goodFrameMinHandHeadVDist))
      ("analysis.goodframemaxheaddisplacement",
       po::value<int>(&analyserOpts.goodFrameMaxHeadDisplacement))
      ("analysis.collectbodyparthistory", po::value<bool>())
      ("analysis.collecthistoryfromambiguousframes",
       po::value<bool>(&analyserOpts.collectHistoryFromAmbiguousFrames))
      ("analysis.bodypartcache", po::value<bool>())
      ("asm.nlandmarks", po::value<int>(&analyserOpts.nlandmarks))
      ("asm.alignthreshold", po::value<double>(&analyserOpts.pdmAlignThreshold))
      ("asm.alignmaxiterations", po::value<unsigned int>(&analyserOpts.pdmAlignMaxIterations))
      ("asm.sobelaperturesize", po::value<string>())
      ("asm.maxlookdistance", po::value<int>(&analyserOpts.asmFittingContext.maxLookDistance))
      ("asm.convergencethreshold", po::value<double>(&analyserOpts.asmFittingContext.convergenceThreshold))
      ("asm.intensityfactor", po::value<double>(&analyserOpts.asmFittingContext.intensityFactor))
      ("asm.minintensity", po::value<string>())
      ("asm.pcacomponentcount", po::value<int>(&analyserOpts.asmFittingContext.pcaComponentCount))
      ("asm.maxiterations", po::value<int>(&analyserOpts.asmFittingContext.maxIterations))
      ("asm.scaleapproximationfactor", po::value<string>())
      ("asm.maxshapeparameterdeviation", po::value<double>(&analyserOpts.asmFittingContext.maxShapeDeviation))
      ("asm.shapehistorysize", po::value<size_t>())
      ("asm.blackout", po::value<bool>(&analyserOpts.asmFittingContext.blackout))
      ("asm.initialposeestimationmethod", po::value<string>())
      ("asm.initialposeestimationgoodnessthreshold",
       po::value<double>(&analyserOpts.asmFittingContext.initialPoseEstimationGoodnessThreshold))
      ("asm.equalisehistogram", po::value<bool>(&analyserOpts.asmFittingContext.equaliseHistogram))
      ("asm.targettype", po::value<string>())
      ("asm.targetmethod", po::value<string>())
      ("asm.gradientmethod", po::value<string>())
      ("asm.cannythreshold1", po::value<double>(&analyserOpts.asmFittingContext.cannyThreshold1))
      ("asm.cannythreshold2", po::value<double>(&analyserOpts.asmFittingContext.cannyThreshold2));

    // load configuration file after parsing the parameters in case
    // --config is set
    std::ifstream ifs(conffile.c_str());
    if (ifs.good()) {
      po::store(po::parse_config_file(ifs, conffileOpts), vm);
      po::notify(vm);
    }
    else {
      cerr << "slmotion: Bad configuration file supplied. No configuration will be read." << endl;
      if (vm.count("config"))
	return -1; // rationale: if default.conf is missing, use built-in
      // values. Only exit the program if the user has specified their own
      // file.
    }
    ifs.close();

    // Parse configuration


    if (vm.count("no-face-detection"))
      analyserOpts.doFaceDetect = false;
    else if (vm.count("global.facedetection"))
      analyserOpts.doFaceDetect = vm["global.facedetection"].as<bool>();

    if (vm.count("verbose") && slmotion::debug < 1) 
      slmotion::debug = 1;

    if (vm.count("video-out"))
      videoOut = true;
    else if (vm.count("global.videooutput"))
      videoOut = vm["global.videooutput"].as<bool>();

    if (vm.count("global.videofps"))
      videoFps = vm["global.videofps"].as<double>();

    if (vm.count("global.videofourcc"))
      videoFourcc = vm["global.videofourcc"].as<string>();



    if (vm.count("pause"))
      analyserOpts.pauseMode = true;

    if (vm.count("no-tracking"))
      analyserOpts.tracking = false;
    else if (vm.count("global.tracking"))
      analyserOpts.tracking = vm["global.tracking"].as<bool>();

    if (vm.count("no-md-analysis"))
      analyserOpts.mdAnalysis = false;
    else if (vm.count("global.mdanalysis"))
      analyserOpts.mdAnalysis = vm["global.mdanalysis"].as<bool>();

    if (vm.count("aspect") || vm.count("global.aspect")) {
      string newAspect = vm.count("aspect") ? vm["aspect"].as<string>() :
	vm["global.aspect"].as<string>();
      double d;
      int x, y;
      aspectCorrection = true; // assume the values are correct until proven otherwise
      if (sscanf(newAspect.c_str(), "%i:%i", &x, &y) == 2)  
	aspect = (static_cast<double>(x) /
		  static_cast<double>(y));
      else if (sscanf(newAspect.c_str(), "%i/%i", &x, &y) == 2)
	aspect = (static_cast<double>(x) /
		  static_cast<double>(y));
      else if (sscanf(newAspect.c_str(), "%lf", &d) < 1) {
	cerr << "slmotion: 'aspect' expects an aspect ratio as its argument"
	     << endl;
	return -1;
      }
      else 
	aspect = d;
    }

    if (vm.count("ann-template-file"))
      analyserOpts.annTemplateFilename = vm["ann-template-file"].as<string>();
    else if (vm.count("global.annotationtemplates"))
      analyserOpts.annTemplateFilename = vm["global.annotationtemplates"].as<string>();

    if (vm.count("show-blob-cent"))
      analyserOpts.showBlobc = true;

    if (vm.count("show-blobs"))
      analyserOpts.showBlobs = true;

    if (vm.count("show-detected-body-parts"))
      analyserOpts.showBodyParts = true;

    if (vm.count("show-estimated-anchors"))
      analyserOpts.showEstimatedAnchors = true;

    if (vm.count("show-asms"))
      analyserOpts.showAsms = true;
 
    if (vm.count("show-gradient-map"))
      analyserOpts.showGradientMap = true;

    if (vm.count("show-gradient-map2d")) {
      analyserOpts.showGradientMap = true;
      analyserOpts.showGradientMap2d = true;
    }

    if (vm.count("show-canny-map"))
      analyserOpts.showCannyMap = true;

    if (vm.count("no-face-cache")) 
      faceDetectorOpts.useCache = false;
    else if (vm.count("facedetection.cache"))
      faceDetectorOpts.useCache = vm["facedetection.cache"].as<bool>();

    if (vm.count("face-cascade"))
      faceDetectorOpts.cascadeFilename = vm["face-cascade"].as<string>();
    else if (vm.count("facedetection.cascade"))
      faceDetectorOpts.cascadeFilename = vm["facedetection.cascade"].as<string>();

    if (vm.count("show-corners"))
      analyserOpts.showCorners = true;

    if (vm.count("show-tracked-points"))
      analyserOpts.showTrackedPoints = true;

    if (vm.count("show-tracked-points2"))
      analyserOpts.showTrackedPoints2 = true;

    if (vm.count("show-face"))
      analyserOpts.showFace = true;

    if (vm.count("show-motion-vectors"))
      analyserOpts.showMvec = true;

    if (vm.count("show-acc-vectors"))
      analyserOpts.showAvec = true;

    if (!vm.count("ann-format") && vm.count("global.annformat"))
      analyserOpts.annFormat = vm["global.annformat"].as<string>();

    if (vm.count("facedetection.scale")) {
      string s = vm["facedetection.scale"].as<string>();
      if (sscanf(s.c_str(), "%lf:%lf", &facescalex, &facescaley) == 2) {
	faceDetectorOpts.faceScalex = facescalex;
	faceDetectorOpts.faceScaley = facescaley;
      }
      else if (sscanf(s.c_str(), "scale=%lf", &facescalex) == 1)  {
	faceDetectorOpts.faceScalex = facescalex;
	faceDetectorOpts.faceScaley = facescalex;

      }
      else {
	cerr << "slmotion: A double or a colon-separated pair of doubles is expected after scale=" << endl;
	return -1;
      }	    
    }
  
    if (vm.count("skin.thresholds")) {
      string s = vm["skin.thresholds"].as<string>();
      int i, j, k, l, m, n;
      if (sscanf(s.c_str(), "%i:%i:%i:%i:%i:%i", &i, &j, &k, &l, &m, &n) 
	  == 6) {
	skinOpts.thresholds[0] = i;
	skinOpts.thresholds[1] = j;
	skinOpts.thresholds[2] = k;
	skinOpts.thresholds[3] = l;
	skinOpts.thresholds[4] = m;
	skinOpts.thresholds[5] = n;
      }
      else
	throw ConfigurationFileException("Invalid number of thresholds given.");
    }
  
    if (vm.count("skin.method")) {
      string s = vm["skin.method"].as<string>();
      if (s == "gauss3d") {
	skinOpts.gauss3d = true;
	skinOpts.adaptiveThresh = false;
	skinOpts.adaptive = false;
      }
      else if (s == "adaptivethresholds") {
	skinOpts.gauss3d = false;
	skinOpts.adaptiveThresh = true;
	skinOpts.adaptive = false;
      }
      else if (s == "opencvadaptive") {
	skinOpts.gauss3d = false;
	skinOpts.adaptiveThresh = false;
	skinOpts.adaptive = true;
      }
      else if (s == "thresholds") {
	skinOpts.gauss3d = false;
	skinOpts.adaptiveThresh = false;
	skinOpts.adaptive = false;
      }
      else 
	throw ConfigurationFileException("Invalid skin filtering method specified.");
    }

    if (vm.count("skin.colourspace")) {
      string s = vm["skin.colourspace"].as<string>();
      if (s == "hsv") 
	skinOpts.colourSpace = slmotion::HSV;
      else if (s == "ycbcr") 
	skinOpts.colourSpace = slmotion::YCbCr;
      else if (s == "rgb")
	skinOpts.colourSpace = slmotion::RGB;
      else 
	throw ConfigurationFileException("Invalid colour space specified.");
    }

    if (vm.count("skin.output")) {
      string s = vm["skin.output"].as<string>();
      if (s == "normal") {
	skinOpts.showMask = false;
	skinOpts.blackOut = false;
      }
      else if (s == "blackout") {
	skinOpts.showMask = false;
	skinOpts.blackOut = true;
      }
      else if (s == "mask") {
	skinOpts.showMask = true;
	skinOpts.blackOut = false;
      }
      else 
	throw ConfigurationFileException("Invalid skin output mode set.");
    }
  

    if (vm.count("skin.fillholes"))
      skinOpts.fillHoles = vm["skin.fillholes"].as<bool>();

    if (vm.count("skin.extcontours"))
      skinOpts.externalContours = vm["skin.extcontours"].as<int>();

    if (vm.count("skin.dilate"))
      skinOpts.dilate = vm["skin.dilate"].as<int>();

    if (vm.count("skin.erode"))
      skinOpts.erode = vm["skin.erode"].as<int>();

    if (vm.count("skin.open"))
      skinOpts.open = vm["skin.open"].as<int>();

    if (vm.count("skin.stdev")) {
      string s = vm["skin.stdev"].as<string>();
      double i, j, k;
      if (sscanf(s.c_str(), "%lf:%lf:%lf", &i, &j, &k) == 3)  {
	skinOpts.stdev[0] = i;
	skinOpts.stdev[1] = j;
	skinOpts.stdev[2] = k;
      }
      else 
	throw ConfigurationFileException("stdev= must receive three colon-separated double arguments.");
    }

    if (vm.count("no-body-part-history-collection"))
      analyserOpts.collectHistory = false;
    else if (vm.count("analysis.collectbodyparthistory"))
      analyserOpts.collectHistory =
	vm["analysis.collectbodyparthistory"].as<bool>();

    if (vm.count("asm.minintensity")) {
      string s = vm["asm.minintensity"].as<string>();
      double d;
      if (s == "mean") 
	analyserOpts.asmFittingContext.minIntensity = -1;
      else if (sscanf(s.c_str(), "%lf", &d) == 1)
	analyserOpts.asmFittingContext.minIntensity = d;
      else
	throw ConfigurationFileException("minintensity= must receive either a floating point value, or \"mean\"");
    }

    if (vm.count("asm.shapehistorysize")) {
      analyserOpts.asmShapeHistorySize = vm["asm.shapehistorysize"].as<size_t>();
    }

    if (vm.count("asm.initialposeestimationmethod")) {
      string s = vm["asm.initialposeestimationmethod"].as<string>();
      if (s == "probeonly")
	analyserOpts.asmFittingContext.initialPoseEstimationMethod =
	  PDM::AsmFittingContext::PROBE_ONLY;
      else if (s == "posehistory")
	analyserOpts.asmFittingContext.initialPoseEstimationMethod =
	  PDM::AsmFittingContext::POSE_HISTORY;
      else if (s == "poseandshapehistory")
	analyserOpts.asmFittingContext.initialPoseEstimationMethod =
	  PDM::AsmFittingContext::POSE_AND_SHAPE_HISTORY;
      else
	throw ConfigurationFileException("Invalid initial pose estimation method selected");
    }

    if (vm.count("asm.targettype")) {
      string s = vm["asm.targettype"].as<string>();
      if (s == "absolute")
	analyserOpts.asmFittingContext.targetType = 
	  PDM::AsmFittingContext::ABSOLUTE;
      else if (s == "negative")
	analyserOpts.asmFittingContext.targetType = 
	  PDM::AsmFittingContext::NEGATIVE;
      else if (s == "positive")
	analyserOpts.asmFittingContext.targetType = 
	  PDM::AsmFittingContext::POSITIVE;
      else
	throw ConfigurationFileException("Invalid target type option selected.");
    }

    if (vm.count("asm.targetmethod")) {
      string s = vm["asm.targetmethod"].as<string>();
      if (s == "gradient")
	analyserOpts.asmFittingContext.targetMethod = PDM::AsmFittingContext::GRADIENT;
      else if (s == "directional")
	analyserOpts.asmFittingContext.targetMethod = PDM::AsmFittingContext::DIRECTIONAL;
      else if (s == "canny")
	analyserOpts.asmFittingContext.targetMethod = PDM::AsmFittingContext::CANNY;
      else
	throw ConfigurationFileException("Invalid target selection method selected.");	
    }

    if (vm.count("asm.gradientmethod")) {
      string s = vm["asm.gradientmethod"].as<string>();
      if (s == "sobel")
	analyserOpts.asmFittingContext.gradientMethod = 
	  PDM::AsmFittingContext::SOBEL;
      else if (s == "laplacian") {
	analyserOpts.asmFittingContext.gradientMethod = 
	  PDM::AsmFittingContext::LAPLACIAN;
	if (analyserOpts.asmFittingContext.targetMethod ==
	    PDM::AsmFittingContext::DIRECTIONAL)
	  throw ConfigurationFileException("Laplacian operator cannot be used with directional targets because it is rotationally invariant");
      }
      else if (s == "laplacian4") {
	analyserOpts.asmFittingContext.gradientMethod = 
	  PDM::AsmFittingContext::LAPLACIAN4;
	if (analyserOpts.asmFittingContext.targetMethod ==
	    PDM::AsmFittingContext::DIRECTIONAL)
	  throw ConfigurationFileException("Laplacian operator cannot be used with directional targets because it is rotationally invariant");
      }
      else if (s == "laplacian8") {
	analyserOpts.asmFittingContext.gradientMethod = 
	  PDM::AsmFittingContext::LAPLACIAN8;
	if (analyserOpts.asmFittingContext.targetMethod ==
	    PDM::AsmFittingContext::DIRECTIONAL)
	  throw ConfigurationFileException("Laplacian operator cannot be used with directional targets because it is rotationally invariant");
      }
      else if (s == "roberts")
	analyserOpts.asmFittingContext.gradientMethod = 
	  PDM::AsmFittingContext::ROBERTS;
      else if (s == "prewitt")
	analyserOpts.asmFittingContext.gradientMethod = 
	  PDM::AsmFittingContext::PREWITT;
      else if (s == "robinson")
	analyserOpts.asmFittingContext.gradientMethod = 
	  PDM::AsmFittingContext::ROBINSON;
      else if (s == "kirsch")
	analyserOpts.asmFittingContext.gradientMethod = 
	  PDM::AsmFittingContext::KIRSCH;
      else
	throw ConfigurationFileException("Invalid gradient approximation method selected.");
    }

    if (analyserOpts.asmShapeHistorySize == 0)
      analyserOpts.asmShapeHistorySize = SIZE_MAX;

    if (vm.count("asm.scaleapproximationfactor")) {
      string s = vm["asm.scaleapproximationfactor"].as<string>();

      double d, e;
      if (sscanf(s.c_str(), "%lf:%lf", &d, &e) == 2) {
	analyserOpts.asmFittingContext.scaleApproximationFactor =
	  std::pair<double, double>(d, e);
      }
      else
	throw ConfigurationFileException("scaleapproximationfactor= must receive either a colon-separated pair of floating point values");
    }

    if (vm.count("no-body-part-classification")) 
      analyserOpts.bodyPartClassification = false;
    else if (vm.count("analysis.bodypartclassification"))
      analyserOpts.bodyPartClassification =
	vm["analysis.bodypartclassification"].as<bool>();

    if (vm.count("no-body-part-cache"))
      analyserOpts.useBodyPartCache = false;
    else if (vm.count("analysis.bodypartcache"))
      analyserOpts.useBodyPartCache = vm["analysis.bodypartcache"].as<bool>();

    if (vm.count("asm.sobelaperturesize")) {
      string s = vm["asm.sobelaperturesize"].as<string>();
      int i;
      if (sscanf(s.c_str(), "%i", &i) == 1) {
	switch(i) {
	case 1:
	case 3:
	case 5:
	case 7:
	  analyserOpts.asmFittingContext.sobelApertureSize = i;
	  break;
	default:
	  throw ConfigurationFileException("Invalid Sobel aperture size specified. Valid values are 1, 3, 5, 7, and scharr.");
	}
      }
      else if (s == "scharr" && 
	       analyserOpts.asmFittingContext.targetMethod == 
	       PDM::AsmFittingContext::DIRECTIONAL)
	analyserOpts.asmFittingContext.sobelApertureSize = CV_SCHARR;
      else if (s == "scharr")
	throw ConfigurationFileException("Invalid Sobel aperture size specified. Scharr filter can only be used with if \"directional\" target method option is used.");
      else
	throw ConfigurationFileException("Invalid Sobel aperture size specified. Valid values are 1, 3, 5, 7, and scharr.");
    }

    if (vm.count("no-blob-detection")) 
      skinOpts.detectBlobs = false;
    else if (vm.count("skin.detectblobs"))
      skinOpts.detectBlobs = vm["skin.detectblobs"].as<bool>();

    if (vm.count("skin.blobremoval")) {
      skinOpts.removeBlobs = vm["skin.blobremoval"].as<bool>();
    }

    if (vm.count("skin.blobs"))
      skinOpts.nBlobs = max(vm["skin.blobs"].as<int>(), 0);
    
    if (vm.count("skin.minblobsize"))
      skinOpts.minBlobSize = max(vm["skin.minblobsize"].as<int>(), 0);

    if (vm.count("skin.minblobdistance"))
      skinOpts.minBlobDist = max(vm["skin.minblobdistance"].as<int>(), 0);

    if (vm.count("skin.crop")) {
      string s = vm["skin.crop"].as<string>();
      int x, y, w, h;
      if (sscanf(s.c_str(), "%i,%i,%i,%i", &x, &y, &w, &h) == 4)
	skinOpts.crop = Rect(x, y, w, h);
      else
	throw ConfigurationFileException("crop= must receive four comma-separated integert arguments.");
    }

    if (vm.count("gauss3d.probthreshold"))
      skinOpts.gauss3dThresh = vm["gauss3d.probthreshold"].as<double>();

    if (vm.count("gauss3d.continuous")) 
      skinOpts.g3dContinuous = vm["gauss3d.continuous"].as<bool>();
    
    if (vm.count("gauss3d.kcolours"))
      skinOpts.g3dkcolours = vm["gauss3d.kcolours"].as<int>();

    if (vm.count("gauss3d.rcolours"))
      skinOpts.g3drcolours = vm["gauss3d.rcolours"].as<int>();

    if (vm.count("gauss3d.cache")) {
      string s = vm["gauss3d.cache"].as<string>();
      if (s == "none" ) {
	skinOpts.g3dNoCache = true;
	skinOpts.g3dUseThresh = false;
      }
      else if (s == "full") {
	skinOpts.g3dNoCache = false;
	skinOpts.g3dUseThresh = false;
      }
      else if (s == "thresholds") {
	skinOpts.g3dNoCache = false;
	skinOpts.g3dUseThresh = true;
      }
      else 
	throw ConfigurationFileException("Invalid 'gauss3dcache' option specified"); 
    }

    if (vm.count("gauss3d.init")) {
      string s = vm["gauss3d.init"].as<string>();
      if (s == "face") {
	analyserOpts.skinFilterG3dInitFromFiles = false;
	analyserOpts.skinFilterG3dInitFromPatches = false;
      }
      else if (s == "file") {
	analyserOpts.skinFilterG3dInitFromFiles = true;
	analyserOpts.skinFilterG3dInitFromPatches = false;
      }
      else if (s == "patchonly") {
	analyserOpts.skinFilterG3dInitFromFiles = false;
	analyserOpts.skinFilterG3dInitFromPatches = true;
      }
      else
	throw ConfigurationFileException("Invalid gauss3d init "\
					 "option specified. \"face\" or "\
					 "\"file\" expected.");
					 
    }

    if (vm.count("gauss3d.initfile")) 
      analyserOpts.skinFilterInitFiles =
	vm["gauss3d.initfile"].as< vector<string> >();

    if (vm.count("cache-out-file")) 
      skinOpts.cacheOutFile = vm["cache-out-file"].as<string>();
    else if (vm.count("gauss3d.cacheoutfile"))
      skinOpts.cacheOutFile = vm["gauss3d.cacheoutfile"].as<string>();

    if (vm.count("vector-out-file"))
      skinOpts.vectorOutFile = vm["vector-out-file"].as<string>();
    else if (vm.count("gauss3d.vectoroutfile"))
      skinOpts.vectorOutFile = vm["gauss3d.vectoroutfile"].as<string>();

    if (vm.count("gauss3d.patch")) {
      vector<string> patchstrings = vm["gauss3d.patch"].as< vector<string> >();
      for (vector<string>::const_iterator it = patchstrings.begin();
	   it != patchstrings.end(); it++) {
	int f, x1, y1, x2, y2, i;
	if (sscanf(it->c_str(), "%i,rectangle,%i,%i,%i,%i,%i",
		   &f, &x1, &y1, &x2, &y2, &i) == 6)   
	  analyserOpts.patches.push_back(slmotion::SkinFilter::SkinPatch(f, slmotion::SkinFilter::SkinPatch::RECTANGLE, Rect(x1, y1, x2-x1, y2-y1), i));
	else if (sscanf(it->c_str(), "%i,ellipse,%i,%i,%i,%i,%i",
		   &f, &x1, &y1, &x2, &y2, &i) == 6)   
	  analyserOpts.patches.push_back(slmotion::SkinFilter::SkinPatch(f, slmotion::SkinFilter::SkinPatch::ELLIPSE, Rect(x1, y1, x2-x1, y2-y1), i));
	else
	  throw ConfigurationFileException("Malformed patch option");
      }

      sort(analyserOpts.patches.begin(), analyserOpts.patches.end());
    }

    if (vm.count("gauss3d.removeoutliers"))
      skinOpts.outlierMaxDist = vm["gauss3d.removeoutliers"].as<int>();

    if (vm.count("gauss3d.clusterattempts"))
      skinOpts.clusterAttempts = vm["gauss3d.clusterattempts"].as<int>();

    if (analyserOpts.skinFilterG3dInitFromFiles && 
	analyserOpts.skinFilterInitFiles.size() == 0) {
	throw ConfigurationFileException("Invalid gauss3d init "\
					 "option specified. \"face\" is "\
					 "set but no initialisation files "\
					 "have been specified.");
    }


    if (vm.count("facedetection.maxmove"))
      faceDetectorOpts.maxMove = vm["facedetection.maxmove"].as<int>();

    if (vm.count("facedetection.maxareachange"))
      faceDetectorOpts.maxAreaChange = vm["facedetection.maxareachange"].
	as<double>();

    if (vm.count("tracking.noblackmask"))
      featureTracker->setNoBlackout(vm["tracking.noblackmask"].as<bool>());
  
    if (vm.count("tracking.preserveoldpoints"))
      featureTracker->setPreserveOldPoints(vm["tracking.preserveoldpoints"].
					   as<bool>());

    if (vm.count("tracking.maxneweigenerror"))
      featureTracker->setMaxNewEigenError(vm["tracking.maxneweigenerror"].
					  as<double>());

    if (vm.count("tracking.maxfoundeigenerror"))
      featureTracker->setMaxFoundEigenError(vm["tracking.maxfoundeigenerror"].
					    as<double>());

    if (vm.count("tracking.maxframeerror"))
      featureTracker->setMaxFrameError(vm["tracking.maxframeerror"].
				       as<double>());
    
    if (vm.count("tracking.gfquality"))
      featureTracker->setQualityLevel(vm["tracking.gfquality"].as<double>());

    if (vm.count("tracking.gfmindistance"))
      featureTracker->setMinDistance(vm["tracking.gfmindistance"].as<double>());

    if (vm.count("tracking.maxpoints"))
      featureTracker->setMaxPoints(vm["tracking.maxpoints"].as<int>());
  
    if (vm.count("tracking.maxmove"))
      featureTracker->setMaxMove(vm["tracking.maxmove"].as<int>());

    // Apply the cache file option
    if (vm.count("cache-file") || vm.count("gauss3d.cachefile")) {

      analyserOpts.cachefile = vm.count("cache-file") ? vm["cache-file"].as<string>() : vm["gauss3d.cachefile"].as<string>();
      std::ifstream f(analyserOpts.cachefile.c_str(), std::ios::binary);
      // the size of the buffer is determined by the size of the largest data member
      char* buff = new char[max(max(sizeof(slmotion::ColourSpace), sizeof(int)), sizeof(double))];

      f.read(buff, sizeof(slmotion::ColourSpace));
      skinOpts.colourSpace = *reinterpret_cast<slmotion::ColourSpace*>(buff);
      f.read(buff, sizeof(int));
      skinOpts.g3dkcolours = *reinterpret_cast<int*>(buff);
      f.read(buff, sizeof(int));
      skinOpts.g3drcolours = *reinterpret_cast<int*>(buff);

      delete[] buff;

      if (skinOpts.colourSpace != slmotion::YCbCr &&
	  skinOpts.colourSpace != slmotion::RGB &&
	  skinOpts.colourSpace != slmotion::HSV)
	throw CommandLineException("Invalid cache file: No such colour space");

      if (skinOpts.g3dkcolours > slmotion::MAXKCOLOURS || skinOpts.g3dkcolours < 1)
	throw CommandLineException("Invalid cache file: Too many or too few colour clusters");

      if (skinOpts.g3drcolours > skinOpts.g3dkcolours || skinOpts.g3drcolours < 0)
	throw CommandLineException("Invalid cache file: Too many or too few relevant colours (with respect to total number of colour clusters)");

      // Then read the actual data

      ddata = auto_ptr< vector<double> >(new vector<double>(256*256*256*skinOpts.g3drcolours));

      if (slmotion::debug)
	cerr << "Reading distribution from a cache file..." << endl;

      f.read((char*)&(*ddata)[0], sizeof(double) * ddata->size());
      f.close();

      skinOpts.ddata = ddata.get();
    }

    if (vm.count("mode") || vm.count("global.mode")) {
      string s = vm.count("mode") ? vm["mode"].as<string>() :
	vm["global.mode"].as<string>();
      if (s == "oldlk")
	analyserOpts.mode = Analyser::AnalyserOpts::OLDLK;
      else if (s == "seglk")
	analyserOpts.mode = Analyser::AnalyserOpts::SEGLK;
      else if (s == "new") {
	analyserOpts.mode = Analyser::AnalyserOpts::NEW;
	analyserOpts.tracking = false;
      }
      else if (s == "all") {
	analyserOpts.mode = Analyser::AnalyserOpts::ALL;
      }
      else
	throw ConfigurationFileException("Invalid mode parameter specified."\
					 " Must be either \"new\" or \"oldlk\"");
    }

    if (vm.count("global.videolibrary")) {
      string s = vm["global.videolibrary"].as<string>();
      if (s == "opencv")
	videoLibrary = SLIO::OPENCV;
#ifdef SLMOTION_WITH_FFMPEG
      else if (s == "ffmpeg") 
	videoLibrary = SLIO::FFMPEG;
#endif
      else
	throw ConfigurationFileException("Unrecognised video library parameter specified.");
    }

    // Make sure that the settings make sense

    if (!skinOpts.detectBlobs || !analyserOpts.doFaceDetect) 
      analyserOpts.bodyPartClassification = false;

    if (!analyserOpts.bodyPartClassification)
      analyserOpts.collectHistory = false;

    if (vm.count("help") || inputName.size() == 0) {
      cerr << "usage: slmotion [options] <file.avi>" << endl;
      cerr << visible << endl;
      cerr << endl << "Versions:" << endl 
	   << "slmotion.C:      " << slmotion_C_vcid << endl
	   << "OpenCV:          " << CV_VERSION << endl;

      cerr << "libxml2:         " << LIBXML_VERSION_STRING[0] << ".";
      if (LIBXML_VERSION_STRING[1] != '0')
	cerr << LIBXML_VERSION_STRING[1];
      cerr << LIBXML_VERSION_STRING[2] << ".";
      if (LIBXML_VERSION_STRING[3] != '0')
	cerr << LIBXML_VERSION_STRING[3];
      cerr << LIBXML_VERSION_STRING[4] << endl;

      return 0;
    }

  }
  catch (ConfigurationFileException& e) {
    cerr << "slmotion: Invalid configuration file supplied: " << e.what()
	 << endl;
    return -1;
  }
  catch (CommandLineException& e) {
    cerr << "slmotion: Invalid command line parameters specified: " <<
      e.what() << "\n";
    return -1;
  }

  // Make sure that settings make sense

  auto_ptr<SLIO> slio(NULL);
  auto_ptr<Analyser> analyser(NULL);
  try {
    slio = auto_ptr<SLIO>(new SLIO(inputName, WINDOWNAME, aspectCorrection, aspect, videoLibrary, analyserOpts.outFilename, videoOut));

    // Create objects using the configuration structs
    if (analyserOpts.annFilename.length() > 0) {
      slio->setAnnFile(analyserOpts.annFilename);
    }

    if (analyserOpts.mdOutFilename.length() > 0) {
      slio->setMdOutFile(analyserOpts.mdOutFilename);
    }

    slio->setOutFps(videoFps);
    analyserOpts.outFps = videoFps;
    slio->setFourcc(videoFourcc);
  
    analyser = auto_ptr<Analyser>(new Analyser(analyserOpts, skinOpts, faceDetectorOpts, *featureTracker, *slio));

    analyser->analyseVideofile();
  } 
  catch (slmotion::SLIOException& e) {
    cerr << "slmotion: ERROR: an exception occurred while performing an I/O "\
      "operation: " << e.what() << endl;
    return -1;
  }
  catch (slmotion::FaceDetectorException& e) {
    cerr << "slmotion: ERROR:  " << e.what() << endl;

    return -1;
  }

  return 0;
}
