#ifndef SLMOTION
#define SLMOTION

#ifdef __GNUC__
#ifndef __clang__
#if (__GNUC__ < 4) || (__GNUC__ == 4 && __GNUC_MINOR__ < 6)
#error Tried to compile using GCC < 4.6. This will not work, since the code uses advanced C++0x constructs (such as Lambda functions, nullptr). Please update your compiler.
#endif
#endif // __clang__
#endif // __GNUC__

#include "UiCallback.hpp"
#include "BlackBoard.hpp"
#include <memory>
#include <string>

/**
 * The default namespace for everything SLMotion related
 */
namespace slmotion {
  /**
   * This variable can be used to enable the global paranoia mode which will
   * affect some video processing functions so that they won't trust video
   * headers etc. at the cost of (a lot of) extra processing time
   */
  extern bool paranoid;

  extern const char* const SLMOTION_VCID;



  /**
   * Returns a string that prints version information of relevant 
   * components
   */
  std::string getVersions();


  
  /**
   * This is the main function. It resides here, so it can also be
   * called from outside the main executable.
   *
   * @param uiCallback UI callback functor (may be used when calling
   * from another program to control the execution)
   */
  int main(int argc, char* argv[], std::shared_ptr<BlackBoard> globalBlackBoard,
           UiCallback* uiCallback);
}

#endif
