#include <iostream>
#include <sstream>
#include "slmotion.hpp"
#include "GaussianSkinDetector.hpp"

using std::cout;
using std::cin;
using std::cerr;
using std::endl;
using std::string;
using std::istringstream;
using std::shared_ptr;

using slmotion::SLIO;
using slmotion::Analyser;
using slmotion::GaussianSkinDetector;
using slmotion::Visualiser;
using slmotion::FaceDetector;
using slmotion::KLTTracker;



namespace {
  //  const string slrecognizermain_cpp_vcid = "$Id: slrecognizermain.cpp,v 1.24 2011-04-15 13:14:31 jmkarppa Exp $";



  inline const char* toChar(const xmlChar* xmlString) {
    return reinterpret_cast<const char*>(xmlString);
  }

  inline std::string getXmlProperty(xmlNodePtr node, const char* property) {
    char* temp = reinterpret_cast<char*>(xmlGetProp(node, reinterpret_cast<const xmlChar*>(property)));
    std::string temp2(temp ? temp : "");
    xmlFree(temp);
    return temp2;
  }
}



namespace slmotion {
  extern int debug;
}

int main() {
#if 0 
  SLIO::setDebugFormat("DEBUG: ", cout);
  SLIO::setWarningFormat("WARN: ", cout);
  SLIO::setInfoFormat("INFO: ", cout);
  const string WINDOWNAME  = "output";

  try {
    // read input call parameters from stdin
    xmlDocPtr input = xmlReadFd(0, NULL, NULL, 0);

    // xmlSaveFile("input.xml", input);

    xmlNodePtr root = xmlDocGetRootElement(input);

    // check the root element
    assert(strcmp(toChar(root->name), "PARAM") == 0);

    // go through elements and set settings accordingly
    string conffile;
    string faceCascade;
    string cacheFile;
    size_t frames = SIZE_MAX;
    size_t skip = 0;
    string annTemplateFile;
    string inputFile;
    string outputFile;

    xmlNodePtr node = xmlFirstElementChild(root);
    while (node) {
      string nodeName = getXmlProperty(node, "name");
      xmlChar* content = xmlNodeGetContent(node);
      istringstream is(reinterpret_cast<char*>(content));
      xmlFree(content);

      if (nodeName == "config")
	is >> conffile;
      else if (nodeName == "facecascade")
	is >> faceCascade;
      else if (nodeName == "anntemplatefile")
	is >> annTemplateFile;
      else if (nodeName == "cachefile")
	is >> cacheFile;
      else if (nodeName == "frames")
	is >> frames;
      else if (nodeName == "skip")
	is >> skip;
      else if (nodeName == "debug")
	is >> slmotion::debug;
      else if (nodeName == "input")
	std::getline(is, inputFile);
      else if (nodeName == "output")
	std::getline(is, outputFile);
      node = xmlNextElementSibling(node);
    }

    xmlFreeDoc(input);

    if (outputFile.length() == 0)
      throw std::invalid_argument("No output file specified.");

    // create necessary structures, and parse the configuration file
    Analyser::AnalyserOpts analyserOpts;
    FaceDetector::FaceDetectorOpts faceDetectorOpts;
    shared_ptr<KLTTracker> ft(new KLTTracker());
    shared_ptr<GaussianSkinDetector> sd(new GaussianSkinDetector);

    analyserOpts.skipFrames = skip;
    analyserOpts.framesMax = frames;

    string trainImage;

    shared_ptr<SLIO> slio(new SLIO(inputFile, WINDOWNAME));
    shared_ptr<Visualiser> visualiser(new Visualiser(slio));

    parseConfigurationFile(conffile, analyserOpts, faceDetectorOpts, *sd, 
                           *ft, *slio, trainImage, *visualiser);

    if (trainImage.length() > 0)
      sd->train(trainImage);
    else 
      sd->train(*slio, faceDetectorOpts);
    
    // Create objects using the configuration structs
    if (analyserOpts.annFilename.length() > 0) {
      slio->loadAnnFile(analyserOpts.annFilename);
    }

    if (analyserOpts.mdOutFilename.length() > 0) {
      slio->setMdOutFile(analyserOpts.mdOutFilename);
    }
  
    std::vector<Analyser> analysers;
    analysers.push_back(Analyser(analyserOpts, sd, faceDetectorOpts, ft, slio, visualiser));
    assert(analysers.size() > 0);
    analysers.front().analyseVideofiles(analysers, outputFile);
  }
  catch (std::exception& e) {
    cout << "ERROR: " << e.what() << endl;
    cout << "RESULT: FAILED." << endl;
    return -1;
  }
  catch (...) {
    cout << "ERROR: Unhandled exception of non-std::exception type caught."
	 << endl;
    cout << "RESULT: FAILED." << endl;
    return -1;
  }
  cout << "RESULT: DONE." << endl;
#endif

    cout << "ERROR: ELAN interface is disabled for the time being." << endl;
    cout << "RESULT: FAILED." << endl;
  return 0;
}
