#include "HandVisualiser.cpp"
#include "HandConfiguration.hpp"
#include <opencv2/opencv.hpp>
// #include <file_dialog.h>
// #include <scene_spec.h>

// int main(int argc, char **argv) {
int main() {
  try {
    slmotion::HandVisualiser hv;

    slmotion::HandConfiguration hc;
 
    const int NUMPAD_4 = 1114036;
    const int NUMPAD_8 = 1114040;
    const int NUMPAD_6 = 1114038;
    const int NUMPAD_2 = 1114034;
    const int NUMPAD_PLUS = 1114027;
    const int NUMPAD_MINUS = 1114029;
    const int NUMPAD_DIV = 1114031;
    const int NUMPAD_MULT = 1114026;
    const float STEP = 3.14159 / 12;

    const int Q = 1048689;

    
    // libhand::FullHandPose hand_pose(scene_spec.num_bones());
    // printf("NUMBER OF JOINTS: %d\n", hand_pose.num_joints());


    int key = 0;
    int i = 0;
    double r, phi, theta, tilt;
    r = phi = theta = 0;
    // tilt = 3.1415/2.;
    tilt = 0;
    #if 0
    while (key != Q) {
      switch (key) {
      case NUMPAD_PLUS:
        r += 1;
        break;
      case NUMPAD_MINUS:
        r -= 1;
        break;
      case NUMPAD_4:
        theta += STEP;
        break;
      case NUMPAD_6:
        theta -= STEP;
        break;
      case NUMPAD_8:
        phi += STEP;
        break;
      case NUMPAD_2:
        phi -= STEP;
        break;
      case NUMPAD_DIV:
        tilt += STEP;
        break;
      case NUMPAD_MULT:
        tilt -= STEP;
        break;
      }

      cv::imshow("Hand", hv.render(hc, r, theta, phi, tilt));
      key = cv::waitKey(20);
    }
    #endif
    r = 10;
    tilt = 3.1415/2.;
    // phi = 3.1415/2.;
    // theta = 3.1415/2.;
    cv::Mat m(25, 1, CV_64FC1, cv::Scalar::all(0));
    cv::Mat n(25, 1, CV_16SC1, cv::Scalar::all(1));
    cv::VideoWriter vw("/users/jmkarppa/twisted_hand.avi", CV_FOURCC('F','M','P','4'), 25, 
                       hv.render(hc, r, theta, phi, tilt).size());
    for (int i = 0; i < 1000; ++i) {
      int k = rand() % m.rows;
      short& sign = n.at<short>(k);
      double& val = m.at<double>(k);
      if (val > 45)
        sign = -1;
      else if (val < -45)
        sign = +1;
      val += sign*45./12.;
      hc = m;
      vw << hv.render(hc, r, theta, phi, tilt);
      std::cout << i << std::endl;
      // cv::imshow("Hand", hv.render(hc, r, theta, phi, tilt));
      // cv::waitKey(40);
      phi = fmod(phi + STEP, 2*3.1415);
    }
  } catch (const std::exception &e) {
    std::cerr << "Exception: " << e.what() << std::endl;
  }
 
  return 0;
}




