//
// This is a test file for Triton, just applies some components to a
// given input file
//

#include "FacialLandmarkDetector.hpp"
#include "OpenCVVideoCaptureVideoFileSource.hpp"

namespace slmotion {
  int debug = 0;

  bool paranoid = false;
}

int main(int argc, char* argv[]) {
  if (argc < 2) {
    std::cerr << "usage: ./tritontest <file.avi>" << std::endl;
    return 1;
  }
  
  std::unique_ptr<slmotion::OpenCVVideoCaptureVideoFileSource> vfs(slmotion::OpenCVVideoCaptureVideoFileSource::create(argv[1]));
  slmotion::BlackBoard bb;
  slmotion::FaceDetector fd(&bb, vfs.get());
  fd.processRange(0, vfs->size());
  slmotion::FacialLandmarkDetector fld(&bb, vfs.get());
  fld.processRange(0, vfs->size());

  return 0;
}
