#include "MemoryStream.hpp"
#include "XmlDocument.hpp"
#include "util.hpp"
#include <cstring>

namespace slmotion {
  std::string getAnnotationSchemaFile() {
    return getInstallPrefix() + "/share/slmotion/annotationtemplate.xsd";
  }


  namespace xml {
    xmlNodePtr getLastChildElementByName(xmlNodePtr parent,
                                         const std::string& name) {
      if (parent == NULL)
	return NULL;
      xmlNodePtr current = xmlFirstElementChild(parent);
      xmlNodePtr rval = NULL;
      while(current) {
	if (strcmp(toChar(current->name), name.c_str()) == 0)
	  rval = current;
	current = xmlNextElementSibling(current);
      }
      return rval;
    }



    xmlNodePtr getChildElementByName(xmlNodePtr parent,
                                     const std::string& name) {
      if (parent == NULL)
	return NULL;

      xmlNodePtr current = xmlFirstElementChild(parent);
      while (current) {
	if (strcmp(toChar(current->name), name.c_str()) == 0)
	  break;

	current = xmlNextElementSibling(current);
      }
      return current;
    }



    void dumpElement(FILE* stream, const XmlDocument& doc, 
                     const XmlNode& element) {
      xmlElemDump(stream, doc.internalDoc.get(), *element.internalNode);
    }



    void dumpElement(std::ostream& stream, const XmlDocument& doc, 
                     const XmlNode& element) {
      MemoryStream memstream;
      dumpElement(memstream, doc, element);
      std::vector<char> memtemp(memstream.getData());
      stream.write(&memtemp[0], memtemp.size());
    }
  }
}
