#include "AdvancedString.hpp"

namespace slmotion {
  AdvancedString& AdvancedString::operator=(const AdvancedString& that) {
    if (this != &that) {
      AdvancedString temp(that);
      std::swap(internalString, temp.internalString);
    }

    return *this;
  }



  std::vector<size_t> AdvancedString::findAll(const AdvancedString& str, 
                                              size_t pos) const {
    std::vector<size_t> poss;
    size_t p;
    while ((p = find(str, pos)) != npos) {
      poss.push_back(p);
      pos = p + 1;
    }
    return poss;
  }



  AdvancedString AdvancedString::replace(const AdvancedString& what, 
                                         const AdvancedString& whatWith, 
                                         size_t pos) const {
    if ((pos = find(what, pos)) != npos)
      return substr(0, pos) + whatWith + substr(pos + what.length());
    else
      return *this;
  }



  AdvancedString AdvancedString::replaceAll(const AdvancedString& what, 
                                            const AdvancedString& whatWith,
                                            size_t pos) const {
    AdvancedString temp = *this;
    size_t len = what.length();
    while ((pos = temp.find(what, pos)) != npos) 
      temp = temp.replace(pos, len, whatWith);
    
    return temp;
  }



  size_t AdvancedString::findRe(const AdvancedString& regex, size_t pos) const {
    std::regex r(regex.internalString);
    std::smatch m;
    if (std::regex_search(internalString.begin() + pos, internalString.end(), m, r))
      return m.position() + pos;
    else
      return npos;
  }



  AdvancedString AdvancedString::replaceRe(const AdvancedString& regex, 
                                           const AdvancedString& str, size_t pos) const {
    std::regex r(regex.internalString);
    return substr(0,pos) + std::regex_replace(internalString.substr(pos), r, str,
                                              std::regex_constants::format_first_only);
  }



  AdvancedString AdvancedString::replaceAllRe(const AdvancedString& regex, 
                                              const AdvancedString& str, size_t pos) const {
    std::regex r(regex.internalString);
    return substr(0,pos) + std::regex_replace(internalString.substr(pos), r, str);
  }



  AdvancedString AdvancedString::operator*(size_t n) const {
    AdvancedString temp;
    for (size_t i = 0; i < n; ++i)
      temp += *this;
    return temp;
  }



  bool AdvancedString::match(const AdvancedString& regexS, size_t pos) const {
    std::regex regex(regexS.substr(pos).internalString);
    std::smatch m;
    return regex_match(internalString, m, regex);
  }



  AdvancedString AdvancedString::join(const std::vector<AdvancedString>& strings) const {
    AdvancedString temp;
    if (strings.size() > 0) {
      temp = strings[0];
      for (auto it = strings.begin() + 1; it != strings.end(); ++it)
        temp += *this + *it;
    }
    return temp;
  }



  AdvancedString AdvancedString::join(const std::vector<std::string>& strings) const {
    AdvancedString temp;
    if (strings.size() > 0) {
      temp = strings[0];
      for (auto it = strings.begin() + 1; it != strings.end(); ++it)
        temp += *this + *it;
    }
    return temp;
  }



  std::vector<AdvancedString> AdvancedString::split(const AdvancedString& str) const {
    std::vector<AdvancedString> strings;
    AdvancedString temp = *this;
    size_t pos = 0;
    size_t len = str.length();
    while ((pos = temp.find(str)) != npos) {
      strings.push_back(temp.substr(0, pos));
      temp = temp.substr(pos + len);
    }
    if (temp.length() > 0)
      strings.push_back(temp);
    return strings;
  }
}
