#ifndef SLMOTION_ANNOTATION_SPECIFIER
#define SLMOTION_ANNOTATION_SPECIFIER

#include <string>
#include <deque>

namespace slmotion {
  /**
   * Annotation specifiers: sets the name of the tier, the minimum number
   * of frames for the annotation to be valid, and any constraints
   */
  struct AnnotationSpecifier {
    /**
     * Describes constraints that each annotation sequence must meet
     */
    struct Constraint {
      /**
       * The type of constraint, i.e. should the values be inside or outside the
       * given maximum and minimum values.
       */
      enum Type {
	INSIDE,
	OUTSIDE,
	INITINSIDE,
	INITOUTSIDE
      } type;
      unsigned int index; ///< Index of the motion descriptor
      double min; ///< Minimum value
      double max; ///< Maximum value
      


      /**
       * Simple constructor
       *
       * @param t Type
       * @param i Index
       * @param min Minimum value
       * @param max Maximum value
       */
      Constraint(Type t, int i, double min, double max) :
	type(t),
	index(i),
	min(min),
	max(max) {}
    };

    std::string name; ///< The name of the tier
    int minLength; ///< Minimum annotation length in frames
    double fps; ///< Framerate
    int padding; ///< Number of extra frames to insert before and after an annotation
    int minGapLength; ///< Minimum lengt for a gap between annotations
    std::deque<Constraint> constraints; ///< The constraints that must be met for a sequence to be valid



    /**
     * Simple constructor
     *
     * @param s Name
     * @param minL Minimum length
     * @param fps Framerate
     * @param consts Constraints
     */
    AnnotationSpecifier(const std::string& s, int minL, double fps,
			int padding, int minGapLength,
                        const std::deque<Constraint>& consts) :
      name(s),
      minLength(minL),
      fps(fps),
      padding(padding),
      minGapLength(minGapLength),
      constraints(consts) {}



    /**
     * Default constructor, creates an empty annotation specifier with 0 minimum
     * length and 25 fps
     */
    AnnotationSpecifier() :
      minLength(0),
      fps(25.0),
      padding(0),
      minGapLength(0) {}
  };
}
#endif
