#ifndef SLMOTION_BIN_CLASSIFIER
#define SLMOTION_BIN_CLASSIFIER

#include "BinaryClassifier.hpp"
#include "TsSomCodebook.hpp"
#include <map>

namespace slmotion {
  class BinClassifier :  public BinaryClassifier {

  public:

    ~BinClassifier(){
      for(size_t l=0;l<tssomlevels.size();l++)
	delete tssomlevels[l];
    }
    

    bool useQuantiser;

    enum QuantiserMode {
      CONSTANT,
      ADAPTIVE,
      VECTORQUANT,
      TSSOMQUANT
      } quantiserMode;

    std::vector<std::vector<float> > quantiserBinUpperLimits; // inclusive

    std::vector<std::vector<float> > codebook;

    std::vector<size_t> quantiserBinCount;

    BinClassifier(){

      useQuantiser=false;
      use_cache=false;
      quantiserMode=CONSTANT;
      znorm=false;
      tssomtrained=false;
    }

    virtual void train(const std::vector<std::vector<float> > &negSamples,
		       const std::vector<std::vector<float> > &posSamples,
		       const std::vector<bool> *dimMask=NULL,
		       const std::vector<float> *negWeights=NULL,
		       const std::vector<float> *posWeights=NULL);

    virtual float predict(const std::vector<float>  &sample,
			  const std::vector<bool> *dimMask=NULL);

    virtual void quantise(const std::vector<float>  &src, 
			  std::vector<float>  &dst);

    virtual void traintssom(const std::vector<std::vector<float> > &negSamples,
		       const std::vector<std::vector<float> > &posSamples,
			    const std::vector<bool> *dimMask=NULL);




    float aprioriprob; // a priori probability of class 1

    std::map<std::vector<float>,float> negCount;
    std::map<std::vector<float>,float> posCount;

    std::vector<float> tssomprob;

    bool use_cache;
    bool znorm;

    bool tssomtrained;

    std::map<std::vector<float>,float> predictioncache;
    std::vector<TsSomCodebook*> tssomlevels;

  };
}
#endif
