#ifndef SLMOTION_BLACKBOARD_EXPLORER
#define SLMOTION_BLACKBOARD_EXPLORER

#include <fstream>
#include "Component.hpp"

namespace slmotion {
  /**
   * This class is a pseudo-component that allows one to explore the
   * contents of the blackboard (and frame source) interactively
   */
  class BlackBoardExplorer : public Component {
  public:
    BlackBoardExplorer(BlackBoard* blackBoard, FrameSource* frameSource) :
      Component(blackBoard, frameSource) {}

    BlackBoardExplorer(bool) : Component(true) {}



    /**
     * Goes interactive
     */
    virtual void process(frame_number_t) {
      goInteractive();
    }



    inline virtual std::string getComponentName() {
      return "BlackBoardExplorer";
    }

    virtual void reset() {}
    virtual std::string getComponentName() const {
      return "BlackBoard Explorer";
    }
    virtual property_set_t getRequirements() const {
      return property_set_t();
    }
    virtual property_set_t getProvided() const {
      return property_set_t();
    }
    virtual std::string getShortName() const {
      return "BlackBoardExplorer";
    }

    virtual std::string getShortDescription() const {
      return "When this component enters processing mode, an interactive shell is "
        "presented on the command line that can be used to explore the content "
        "of the black board";
    }

    virtual std::string getLongDescription() const {
      return "When this component enters processing mode, an interactive shell is "
        "presented on the command line that can be used to explore the content "
        "of the black board";
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const {
      return boost::program_options::options_description();
    }

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map&, BlackBoard* b, FrameSource* f) const {
      return new BlackBoardExplorer(b, f);
    }



    /**
     * Goes interactive
     */
    virtual bool processRangeImplementation(frame_number_t, 
                                            frame_number_t, 
                                            UiCallback*) {
      goInteractive();
      return true;
    }



    void goInteractive();
  };
}

#endif
